/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.servohub.ServoChannel;
import com.revrobotics.servohub.config.ServoChannelConfig;

public class ServoHubConfig
extends BaseConfig {
    public final ServoChannelConfig channel0 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId0);
    public final ServoChannelConfig channel1 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId1);
    public final ServoChannelConfig channel2 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId2);
    public final ServoChannelConfig channel3 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId3);
    public final ServoChannelConfig channel4 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId4);
    public final ServoChannelConfig channel5 = new ServoChannelConfig(ServoChannel.ChannelId.kChannelId5);
    private final ServoChannelConfig[] channelConfigs = new ServoChannelConfig[]{this.channel0, this.channel1, this.channel2, this.channel3, this.channel4, this.channel5};

    public ServoHubConfig() {
        super(BaseConfig.CANType.kServoHub);
    }

    public ServoHubConfig apply(ServoHubConfig config) {
        super.apply(config);
        this.channel0.apply(config.channel0);
        this.channel1.apply(config.channel1);
        this.channel2.apply(config.channel2);
        this.channel3.apply(config.channel3);
        this.channel4.apply(config.channel4);
        this.channel5.apply(config.channel5);
        return this;
    }

    public ServoHubConfig apply(ServoChannel.ChannelId channelId, ServoChannelConfig config) {
        this.channelConfigs[channelId.value].apply(config);
        return this;
    }

    @Override
    public String flatten() {
        String flattenedString = super.flatten() + this.channel0.flatten() + this.channel1.flatten() + this.channel2.flatten() + this.channel3.flatten() + this.channel4.flatten() + this.channel5.flatten();
        return flattenedString;
    }
}

