/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.sim;

import edu.wpi.first.math.Pair;
import edu.wpi.first.math.filter.LinearFilter;

public class MovingAverageFilterSim {
    private final LinearFilter m_filter;
    private double m_value = 0.0;
    private final double m_sampleRate;
    private Pair<Double, Double> m_state = new Pair((Object)0.0, (Object)0.0);

    public MovingAverageFilterSim(int taps, double sampleRate) {
        this.m_sampleRate = sampleRate;
        this.m_filter = LinearFilter.movingAverage((int)taps);
    }

    private double lerp(Pair<Double, Double> p1, Pair<Double, Double> p2, double x) {
        if (p2.getFirst() == p1.getFirst()) {
            return (Double)p2.getSecond();
        }
        return (Double)p1.getSecond() + (x - (Double)p1.getFirst()) * (((Double)p2.getSecond() - (Double)p1.getSecond()) / ((Double)p2.getFirst() - (Double)p1.getFirst()));
    }

    public void put(double value, double delta) {
        double newDelta;
        for (newDelta = (Double)this.m_state.getFirst() + delta; newDelta >= this.m_sampleRate; newDelta -= this.m_sampleRate) {
            this.m_value = this.m_filter.calculate(this.lerp(this.m_state, (Pair<Double, Double>)new Pair((Object)newDelta, (Object)value), this.m_sampleRate));
        }
        this.m_state = new Pair((Object)newDelta, (Object)value);
    }

    public double get() {
        return this.m_value;
    }
}

