/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefDevToolsMessageObserver;
import org.cef.browser.CefRegistration;

public class CefDevToolsClient
implements AutoCloseable {
    private final Map<Integer, CompletableFuture<String>> queuedCommands_ = Collections.synchronizedMap(new HashMap());
    private final Set<EventListener> eventListeners_ = Collections.synchronizedSet(new LinkedHashSet());
    private CefRegistration registration_;
    private final CefBrowser_N browser_;

    CefDevToolsClient(CefBrowser_N browser) {
        this.browser_ = browser;
        this.registration_ = browser.addDevToolsMessageObserver(new CefDevToolsMessageObserver(){

            @Override
            public void onDevToolsMethodResult(CefBrowser browser, int messageId, boolean success, String result) {
                CompletableFuture future = CefDevToolsClient.this.getQueuedCommand(messageId);
                if (success) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(new DevToolsException("DevTools method failed", result));
                }
            }

            @Override
            public void onDevToolsEvent(CefBrowser browser, String method, String parameters) {
                for (EventListener eventListener : CefDevToolsClient.this.eventListeners_) {
                    eventListener.onEvent(method, parameters);
                }
            }
        });
    }

    @Override
    public void close() {
        this.queuedCommands_.clear();
        this.eventListeners_.clear();
        this.registration_ = null;
    }

    public boolean isClosed() {
        return this.registration_ == null;
    }

    private CompletableFuture<String> getQueuedCommand(Integer messageId) {
        return this.queuedCommands_.computeIfAbsent(messageId, key -> new CompletableFuture());
    }

    public CompletableFuture<String> executeDevToolsMethod(String method) {
        return this.executeDevToolsMethod(method, null);
    }

    public CompletableFuture<String> executeDevToolsMethod(String method, String parametersAsJson) {
        if (this.isClosed()) {
            CompletableFuture<String> future = new CompletableFuture<String>();
            future.completeExceptionally(new DevToolsException("Client is closed"));
            return future;
        }
        return this.browser_.executeDevToolsMethod(method, parametersAsJson).thenCompose(this::getQueuedCommand);
    }

    public void addEventListener(EventListener eventListener) {
        this.eventListeners_.add(eventListener);
    }

    public void removeEventListener(EventListener eventListener) {
        this.eventListeners_.remove(eventListener);
    }

    public static final class DevToolsException
    extends Exception {
        private static final long serialVersionUID = 3952948449841375372L;
        private final String json_;

        public DevToolsException(String message) {
            this(message, (String)null);
        }

        public DevToolsException(String message, String json) {
            super(message);
            this.json_ = json;
        }

        @Override
        public String getMessage() {
            String message = super.getMessage();
            if (this.json_ != null) {
                message = message + ": " + this.json_;
            }
            return message;
        }

        public String getJson() {
            return this.json_;
        }
    }

    public static interface EventListener {
        public void onEvent(String var1, String var2);
    }
}

