/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import io.micrometer.context.ThreadLocalAccessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestAttributesThreadLocalAccessor
implements ThreadLocalAccessor<RequestAttributes> {
    public static final String KEY = RequestAttributesThreadLocalAccessor.class.getName() + ".KEY";

    public Object key() {
        return KEY;
    }

    public @Nullable RequestAttributes getValue() {
        ServletRequestAttributes sra;
        RequestAttributes request = RequestContextHolder.getRequestAttributes();
        if (request instanceof ServletRequestAttributes && !((sra = (ServletRequestAttributes)request) instanceof SnapshotServletRequestAttributes)) {
            request = new SnapshotServletRequestAttributes(sra);
        }
        return request;
    }

    public void setValue(RequestAttributes value) {
        RequestContextHolder.setRequestAttributes(value);
    }

    public void setValue() {
        RequestContextHolder.resetRequestAttributes();
    }

    private static final class SnapshotServletRequestAttributes
    extends ServletRequestAttributes {
        private final ServletRequestAttributes delegate;
        private final Map<String, Object> attributeMap;

        public SnapshotServletRequestAttributes(ServletRequestAttributes requestAttributes) {
            super(requestAttributes.getRequest(), requestAttributes.getResponse());
            this.delegate = requestAttributes;
            this.attributeMap = SnapshotServletRequestAttributes.getAttributes(requestAttributes.getRequest());
        }

        private static Map<String, Object> getAttributes(HttpServletRequest request) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, request.getAttribute(name));
            }
            return map;
        }

        @Override
        public @Nullable Object getAttribute(String name, int scope) {
            if (scope == 0 && !this.delegate.isRequestActive()) {
                return this.attributeMap.get(name);
            }
            try {
                return this.delegate.getAttribute(name, scope);
            }
            catch (IllegalStateException ex) {
                if (scope == 0) {
                    return this.attributeMap.get(name);
                }
                throw ex;
            }
        }

        @Override
        public String[] getAttributeNames(int scope) {
            if (scope == 0 && !this.delegate.isRequestActive()) {
                return this.attributeMap.keySet().toArray(new String[0]);
            }
            try {
                return this.delegate.getAttributeNames(scope);
            }
            catch (IllegalStateException ex) {
                if (scope == 0) {
                    return this.attributeMap.keySet().toArray(new String[0]);
                }
                throw ex;
            }
        }

        @Override
        public void setAttribute(String name, Object value, int scope) {
            this.delegate.setAttribute(name, value, scope);
        }

        @Override
        public void removeAttribute(String name, int scope) {
            this.delegate.removeAttribute(name, scope);
        }
    }
}

