/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalTimeJavaType
extends AbstractTemporalJavaType<LocalTime> {
    public static final LocalTimeJavaType INSTANCE = new LocalTimeJavaType();

    public LocalTimeJavaType() {
        super(LocalTime.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        if (context.isPreferJavaTimeJdbcTypesEnabled()) {
            return context.getJdbcType(3011);
        }
        return context.getJdbcType(92);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(LocalTime value) {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(value);
    }

    @Override
    public LocalTime fromString(CharSequence string) {
        return LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(LocalTime value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time time = Time.valueOf(value);
            if (value.getNano() == 0) {
                return (X)time;
            }
            return (X)new Time(time.getTime() + DateTimeUtils.roundToPrecision(value.getNano(), 3) / 1000000L);
        }
        ZonedDateTime zonedDateTime = value.atDate(LocalDate.of(1970, 1, 1)).atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.from(instant);
        }
        if (Date.class.equals(type)) {
            return (X)Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalTime) {
            LocalTime localTime = (LocalTime)value;
            return localTime;
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            LocalTime localTime = time.toLocalTime();
            long millis = time.getTime() % 1000L;
            if (millis == 0L) {
                return localTime;
            }
            if (millis < 0L) {
                millis += 1000L;
            }
            return localTime.with(ChronoField.NANO_OF_SECOND, millis * 1000000L);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return LocalDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            Instant instant = Instant.ofEpochMilli(longValue);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalTime();
        }
        if (value instanceof Date) {
            Date timestamp = (Date)value;
            Instant instant = Instant.ofEpochMilli(timestamp.getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "java.sql.Time" -> true;
            default -> false;
        };
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return 0;
    }
}

