/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.bootloader;

public final class CRC32Mpeg2 {
    private static final int POLY = 79764919;
    private static final int[] TABLE = new int[256];
    private int crc = -1;

    public void update(byte[] data) {
        for (byte b : data) {
            int index = (this.crc >>> 24 ^ b & 0xFF) & 0xFF;
            this.crc = this.crc << 8 ^ TABLE[index];
        }
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public void reset() {
        this.crc = -1;
    }

    public static long compute(byte[] data) {
        CRC32Mpeg2 c = new CRC32Mpeg2();
        c.update(data);
        return c.getValue();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int crc = i << 24;
            for (int j = 0; j < 8; ++j) {
                if ((crc & Integer.MIN_VALUE) != 0) {
                    crc = crc << 1 ^ 0x4C11DB7;
                    continue;
                }
                crc <<= 1;
            }
            CRC32Mpeg2.TABLE[i] = crc;
        }
    }
}

