/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.data.web.ProjectedPayload;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.util.Assert;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.json.JsonMapper;

public class ProjectingJacksonHttpMessageConverter
extends JacksonJsonHttpMessageConverter
implements BeanClassLoaderAware,
BeanFactoryAware {
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private final Map<Class<?>, Boolean> supportedTypesCache = new ConcurrentHashMap();

    public ProjectingJacksonHttpMessageConverter() {
        this.projectionFactory = ProjectingJacksonHttpMessageConverter.initProjectionFactory(this.getMapper());
    }

    public ProjectingJacksonHttpMessageConverter(JsonMapper mapper) {
        super(mapper);
        this.projectionFactory = ProjectingJacksonHttpMessageConverter.initProjectionFactory((ObjectMapper)mapper);
    }

    private static SpelAwareProxyProjectionFactory initProjectionFactory(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.registerMethodInvokerFactory(new JsonProjectingMethodInterceptorFactory((JsonProvider)new JacksonJsonProvider(mapper), new JacksonMappingProvider(mapper)));
        return projectionFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.projectionFactory.setBeanClassLoader(classLoader);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.projectionFactory.setBeanFactory(beanFactory);
    }

    protected boolean supports(Class<?> clazz) {
        if (clazz.isInterface()) {
            Boolean result = this.supportedTypesCache.get(clazz);
            if (result != null) {
                return result;
            }
            result = AnnotationUtils.findAnnotation(clazz, ProjectedPayload.class) != null;
            this.supportedTypesCache.put(clazz, result);
            return result;
        }
        return false;
    }

    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        if (!super.canRead(type, mediaType)) {
            return false;
        }
        Class clazz = type.resolve();
        if (clazz == null) {
            return false;
        }
        return this.supports(clazz);
    }

    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return false;
    }

    public Object read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        return this.projectionFactory.createProjection(type.resolve(Object.class), (Object)inputMessage.getBody());
    }

    static class JacksonJsonProvider
    extends AbstractJsonProvider {
        private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
        private static final ObjectReader defaultObjectReader = defaultObjectMapper.reader().forType(Object.class);
        protected ObjectMapper objectMapper;
        protected ObjectReader objectReader;

        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        public JacksonJsonProvider() {
            this(defaultObjectMapper, defaultObjectReader);
        }

        public JacksonJsonProvider(ObjectMapper objectMapper) {
            this(objectMapper, objectMapper.readerFor(Object.class));
        }

        public JacksonJsonProvider(ObjectMapper objectMapper, ObjectReader objectReader) {
            this.objectMapper = objectMapper;
            this.objectReader = objectReader;
        }

        public Object parse(String json) throws InvalidJsonException {
            return this.objectReader.readValue(json);
        }

        public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
            try {
                return this.objectReader.readValue((Reader)new InputStreamReader(jsonStream, charset));
            }
            catch (IOException e) {
                throw new InvalidJsonException((Throwable)e);
            }
        }

        public String toJson(Object obj) {
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator generator = this.objectMapper.writer().createGenerator((Writer)writer);
                this.objectMapper.writeValue(generator, obj);
                writer.flush();
                writer.close();
                generator.close();
                return writer.getBuffer().toString();
            }
            catch (IOException e) {
                throw new InvalidJsonException((Throwable)e);
            }
        }

        public List<Object> createArray() {
            return new LinkedList<Object>();
        }

        public Object createMap() {
            return new LinkedHashMap();
        }
    }

    record JacksonMappingProvider(ObjectMapper objectMapper) implements MappingProvider
    {
        public <T> @Nullable T map(@Nullable Object source, Class<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            try {
                return (T)this.objectMapper.convertValue(source, targetType);
            }
            catch (Exception e) {
                throw new MappingException((Throwable)e);
            }
        }

        public <T> @Nullable T map(@Nullable Object source, TypeRef<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
            try {
                return (T)this.objectMapper.convertValue(source, type);
            }
            catch (Exception e) {
                throw new MappingException((Throwable)e);
            }
        }
    }
}

