/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.jni.REVLibJNI;
import com.revrobotics.revlib.support.DriverSetup;
import com.revrobotics.revlib.support.RevLibBridge;
import com.revrobotics.revui.app.LogPathInitializer;
import com.revrobotics.revui.app.REVUIApplication;
import com.revrobotics.revui.app.ui.AppSplashScreen;
import com.revrobotics.revui.app.ui.Window;
import com.revrobotics.util.StatusLogger;
import java.awt.Desktop;
import java.awt.SplashScreen;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

public class Main
implements Runnable {
    @CommandLine.Option(names={"--show-ui"}, description={"Whether to run headless"}, defaultValue="false")
    boolean showUi;
    @CommandLine.Option(names={"--show-swagger"}, description={"Whether to open swagger"}, defaultValue="false")
    boolean showSwagger;
    String[] args;
    SplashScreen splash;

    Main(String[] args) {
        this.args = args;
    }

    public static void main(String[] args) {
        System.setProperty("jna.nounpack", "false");
        LogPathInitializer.init();
        CommandLine commandLine = new CommandLine((Object)new Main(args));
        commandLine.execute(args);
    }

    private void showSplashScreen() {
        AppSplashScreen.showSplashScreen();
    }

    @Override
    public void run() {
        SpringApplication app = new SpringApplication(new Class[]{REVUIApplication.class});
        System.setProperty("java.awt.headless", String.valueOf(!this.showUi && !this.showSwagger));
        if (this.showUi || this.showSwagger) {
            this.showSplashScreen();
        }
        Main.initRevLib();
        app.addListeners(new ApplicationListener[]{event -> {
            int port;
            ConfigurableEnvironment env = event.getApplicationContext().getEnvironment();
            String specifiedPort = env.getProperty("local.server.port");
            int n = port = specifiedPort == null ? 8080 : Integer.parseInt(specifiedPort);
            if (this.showUi) {
                Window window = Window.getInstance();
                window.start(port);
            } else if (this.showSwagger) {
                AppSplashScreen.closeSplashScreen();
                String contextPath = env.getProperty("server.servlet.context-path", "");
                String url = "http://localhost:" + port + contextPath + "/swagger-ui/index.html";
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI(url));
                    }
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }});
        app.run(this.args);
    }

    private static void initRevLib() {
        System.setProperty("com.revrobotics.no-jni", "true");
        System.setProperty("com.revrobotics.revui.disable.set.motor", "true");
        DriverSetup.setupBackendDriver();
        RevLibBridge.load();
        StatusLogger.disableAutoLogging();
        REVLibJNI.c_REVLib_SetBaseDefaultCanRetries((int)1);
        REVLibJNI.c_REVLib_SetBaseDefaultCanTimeoutMs((int)10);
    }
}

