/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class MessagesWebsocketHandler
extends TextWebSocketHandler {
    @Autowired
    CanBridge bridge;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, ScheduledFuture<?>> tasksBySession = new HashMap();

    public void afterConnectionEstablished(WebSocketSession session) {
        this.bridge.scanForBuses();
        String descriptor = this.getParam(session, "descriptor");
        CanBus bus = descriptor == null ? this.bridge.getBuses()[0] : this.bridge.getBusOrNull(descriptor);
        ScheduledFuture<?> task = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                CanMessage[] messages = this.bridge.getLatestMessages(bus, 1000);
                String data = objectMapper.writeValueAsString((Object)messages);
                if (session.isOpen()) {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)data));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        this.tasksBySession.put(session.getId(), task);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        System.err.println("WebSocket error: " + exception.getMessage());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        System.out.println("WebSocket closed: " + String.valueOf(status));
        ScheduledFuture<?> task = this.tasksBySession.remove(session.getId());
        if (task != null) {
            task.cancel(true);
        }
    }

    private String getParam(WebSocketSession session, String name) {
        String query;
        URI uri = session.getUri();
        if (uri != null && (query = uri.getQuery()) != null) {
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                if (pair.length != 2 || !pair[0].equals(name)) continue;
                return pair[1];
            }
        }
        return null;
    }
}

