/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.context;

import java.util.Locale;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.web.server.context.MissingWebServerFactoryBeanException;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Order(value=0)
class MissingWebServerFactoryBeanFailureAnalyzer
extends AbstractFailureAnalyzer<MissingWebServerFactoryBeanException> {
    MissingWebServerFactoryBeanFailureAnalyzer() {
    }

    protected FailureAnalysis analyze(Throwable rootFailure, MissingWebServerFactoryBeanException cause) {
        Class beanType = cause.getBeanType();
        Assert.state((beanType != null ? 1 : 0) != 0, (String)"'beanType' must not be null");
        return new FailureAnalysis("Web application could not be started as there was no " + beanType.getName() + " bean defined in the context.", "Check your application's dependencies for a supported " + cause.getWebApplicationType().name().toLowerCase(Locale.ENGLISH) + " web server.\nCheck the configured web application type.", (Throwable)((Object)cause));
    }
}

