/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.ColorMatchResult;
import edu.wpi.first.wpilibj.util.Color;
import java.util.ArrayList;

public class ColorMatch {
    private static final double kDefaultConfidence = 0.95;
    private double m_confidenceLevel = 0.95;
    private ArrayList<Color> m_colorsToMatch = new ArrayList();

    private static double CalculateDistance(Color color1, Color color2) {
        double redDiff = color1.red - color2.red;
        double greenDiff = color1.green - color2.green;
        double blueDiff = color1.blue - color2.blue;
        return Math.sqrt((redDiff * redDiff + greenDiff * greenDiff + blueDiff * blueDiff) / 2.0);
    }

    public void addColorMatch(Color color) {
        this.m_colorsToMatch.add(color);
    }

    public void setConfidenceThreshold(double confidence) {
        if (confidence < 0.0) {
            confidence = 0.0;
        } else if (confidence > 1.0) {
            confidence = 1.0;
        }
        this.m_confidenceLevel = confidence;
    }

    public ColorMatchResult matchColor(Color colorToMatch) {
        ColorMatchResult match = this.matchClosestColor(colorToMatch);
        if (match.confidence > this.m_confidenceLevel) {
            return match;
        }
        return null;
    }

    public ColorMatchResult matchClosestColor(Color color) {
        double magnitude = color.red + color.blue + color.green;
        if (magnitude > 0.0 && this.m_colorsToMatch.size() > 0) {
            double minDistance = 1.0;
            int idx = 0;
            for (int i = 0; i < this.m_colorsToMatch.size(); ++i) {
                double targetDistance = ColorMatch.CalculateDistance(this.m_colorsToMatch.get(i), color);
                if (!(targetDistance < minDistance)) continue;
                minDistance = targetDistance;
                idx = i;
            }
            ColorMatchResult match = new ColorMatchResult(this.m_colorsToMatch.get(idx), 1.0 - minDistance / magnitude);
            return match;
        }
        return new ColorMatchResult(Color.kBlack, 0.0);
    }
}

