/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.FeedbackSensor;
import com.revrobotics.spark.config.FeedForwardConfig;
import com.revrobotics.spark.config.MAXMotionConfig;
import com.revrobotics.spark.config.SparkParameters;

public class ClosedLoopConfig
extends BaseConfig {
    public final MAXMotionConfig maxMotion = new MAXMotionConfig();
    public final FeedForwardConfig feedForward = new FeedForwardConfig();

    public ClosedLoopConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public ClosedLoopConfig apply(ClosedLoopConfig config) {
        super.apply(config);
        this.maxMotion.apply(config.maxMotion);
        this.feedForward.apply(config.feedForward);
        return this;
    }

    public ClosedLoopConfig apply(MAXMotionConfig config) {
        this.maxMotion.apply(config);
        return this;
    }

    public ClosedLoopConfig apply(FeedForwardConfig config) {
        this.feedForward.apply(config);
        return this;
    }

    @Deprecated(forRemoval=true)
    public ClosedLoopConfig pidf(double p, double i, double d, double ff) {
        return this.pidf(p, i, d, ff, ClosedLoopSlot.kSlot0);
    }

    @Deprecated(forRemoval=true)
    public ClosedLoopConfig pidf(double p, double i, double d, double ff, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kP_0.value + slot.value * 8, (float)p);
        this.putParameter(SparkParameters.kI_0.value + slot.value * 8, (float)i);
        this.putParameter(SparkParameters.kD_0.value + slot.value * 8, (float)d);
        this.putParameter(SparkParameters.kV_0.value + slot.value * 8, (float)ff);
        return this;
    }

    public ClosedLoopConfig pid(double p, double i, double d) {
        return this.pid(p, i, d, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig pid(double p, double i, double d, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kP_0.value + slot.value * 8, (float)p);
        this.putParameter(SparkParameters.kI_0.value + slot.value * 8, (float)i);
        this.putParameter(SparkParameters.kD_0.value + slot.value * 8, (float)d);
        return this;
    }

    public ClosedLoopConfig p(double p) {
        return this.p(p, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig p(double p, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kP_0.value + slot.value * 8, (float)p);
        return this;
    }

    public ClosedLoopConfig i(double i) {
        return this.i(i, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig i(double i, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kI_0.value + slot.value * 8, (float)i);
        return this;
    }

    public ClosedLoopConfig d(double d) {
        return this.d(d, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig d(double d, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kD_0.value + slot.value * 8, (float)d);
        return this;
    }

    @Deprecated(forRemoval=true)
    public ClosedLoopConfig velocityFF(double ff) {
        return this.velocityFF(ff, ClosedLoopSlot.kSlot0);
    }

    @Deprecated(forRemoval=true)
    public ClosedLoopConfig velocityFF(double ff, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kV_0.value + slot.value * 8, (float)ff);
        return this;
    }

    public ClosedLoopConfig dFilter(double dFilter) {
        return this.dFilter(dFilter, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig dFilter(double dFilter, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kDFilter_0.value + slot.value * 8, (float)dFilter);
        return this;
    }

    public ClosedLoopConfig iZone(double iZone) {
        return this.iZone(iZone, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig iZone(double iZone, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kIZone_0.value + slot.value * 8, (float)iZone);
        return this;
    }

    public ClosedLoopConfig minOutput(double minOutput) {
        return this.minOutput(minOutput, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig minOutput(double minOutput, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kOutputMin_0.value + slot.value * 8, (float)minOutput);
        return this;
    }

    public ClosedLoopConfig maxOutput(double maxOutput) {
        return this.maxOutput(maxOutput, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig maxOutput(double maxOutput, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kOutputMax_0.value + slot.value * 8, (float)maxOutput);
        return this;
    }

    public ClosedLoopConfig outputRange(double minOutput, double maxOutput) {
        return this.outputRange(minOutput, maxOutput, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig outputRange(double minOutput, double maxOutput, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kOutputMin_0.value + slot.value * 8, (float)minOutput);
        this.putParameter(SparkParameters.kOutputMax_0.value + slot.value * 8, (float)maxOutput);
        return this;
    }

    public ClosedLoopConfig iMaxAccum(double iMaxAccum) {
        return this.iMaxAccum(iMaxAccum, ClosedLoopSlot.kSlot0);
    }

    public ClosedLoopConfig iMaxAccum(double iMaxAccum, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kIMaxAccum_0.value + slot.value * 4, (float)iMaxAccum);
        return this;
    }

    public ClosedLoopConfig allowedClosedLoopError(double allowedError, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kAllowedClosedLoopError_0.value + slot.value * 4, (float)allowedError);
        return this;
    }

    public ClosedLoopConfig positionWrappingEnabled(boolean enabled) {
        this.putParameter(SparkParameters.kPositionPIDWrapEnable.value, enabled);
        return this;
    }

    public ClosedLoopConfig positionWrappingMinInput(double minInput) {
        this.putParameter(SparkParameters.kPositionPIDMinInput.value, (float)minInput);
        return this;
    }

    public ClosedLoopConfig positionWrappingMaxInput(double maxInput) {
        this.putParameter(SparkParameters.kPositionPIDMaxInput.value, (float)maxInput);
        return this;
    }

    public ClosedLoopConfig positionWrappingInputRange(double minInput, double maxInput) {
        this.putParameter(SparkParameters.kPositionPIDMinInput.value, (float)minInput);
        this.putParameter(SparkParameters.kPositionPIDMaxInput.value, (float)maxInput);
        return this;
    }

    public ClosedLoopConfig feedbackSensor(FeedbackSensor sensor) {
        this.putParameter(SparkParameters.kClosedLoopControlSensor.value, sensor.value);
        return this;
    }

    @Override
    public String flatten() {
        String flattenedString = "";
        flattenedString = flattenedString + super.flatten();
        flattenedString = flattenedString + this.maxMotion.flatten();
        flattenedString = flattenedString + this.feedForward.flatten();
        return flattenedString;
    }
}

