/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.revrobotics.PneumaticHubStatusEmitter;
import com.revrobotics.PowerHubStatusEmitter;
import com.revrobotics.ServoHubStatusFrameEmitter;
import com.revrobotics.SparkStatusFrameEmitter;
import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.DeviceManager;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.servohub.ServoHub;
import com.revrobotics.spark.SparkBase;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class StatusFrameWebsocketHandler
extends TextWebSocketHandler {
    @Autowired
    DeviceDaemon deviceDaemon;
    public static StatusFrameWebsocketHandler INSTANCE;
    private final Map<String, WebSocketSession> sessions = new HashMap<String, WebSocketSession>();
    private final Map<String, String> sessionIdToKeyMap = new HashMap<String, String>();

    public StatusFrameWebsocketHandler() {
        INSTANCE = this;
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String key;
        Object command2;
        super.handleTextMessage(session, message);
        String text = (String)message.getPayload();
        ObjectMapper mapper = new ObjectMapper();
        try {
            command2 = (FrameEnableCommand)mapper.readValue(text, FrameEnableCommand.class);
            key = this.sessionIdToKeyMap.get(session.getId());
            DeviceManager.StatusFrameEmitterHolder emitterHolder = this.deviceDaemon.getDeviceManager().getSparkStatusFrameEmitter(key);
            for (FrameEnabledState state : ((FrameEnableCommand)command2).getStates()) {
                this.updateFrameEnabled(session, state, emitterHolder);
            }
        }
        catch (JsonProcessingException command2) {
            // empty catch block
        }
        try {
            command2 = (CreateKeyCommand)mapper.readValue(text, CreateKeyCommand.class);
            key = ((CreateKeyCommand)command2).key;
            if (this.sessions.get(key) != null) {
                return;
            }
            this.sessions.put(key, session);
            this.sessionIdToKeyMap.put(session.getId(), key);
            this.deviceDaemon.getDeviceManager().addSparkStatusEmitterMap(key);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void updateFrameEnabled(String sessionId, String descriptor, UUID uuid, int index, boolean enabled) {
        WebSocketSession session = this.sessions.get(sessionId);
        if (session == null) {
            return;
        }
        DeviceManager.StatusFrameEmitterHolder emitterHolder = this.deviceDaemon.getDeviceManager().getSparkStatusFrameEmitter(sessionId);
        FrameEnabledState state = new FrameEnabledState();
        state.descriptor = CanBridgeController.encodeDescriptor(descriptor);
        state.uuid = uuid;
        state.index = index;
        state.enabled = enabled;
        this.updateFrameEnabled(session, state, emitterHolder);
    }

    private void updateFrameEnabled(WebSocketSession session, FrameEnabledState state, DeviceManager.StatusFrameEmitterHolder emitterHolder) {
        StatusFrameEmitter emitter;
        String descriptor = CanBridgeController.decodeDescriptor(state.descriptor);
        DeviceManager.FullDeviceIdentifier identifier = new DeviceManager.FullDeviceIdentifier(descriptor, state.uuid);
        if (emitterHolder.getEmitter(identifier) == null) {
            FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(descriptor, state.uuid);
            if (device == null) {
                return;
            }
            if (device.type() != null && device.type().isSPARK() ? !this.addSparkEmitter(session, device, emitterHolder, identifier) : (device.type() == RecognizedDevice.SERVO_HUB ? !this.addServoHubEmitter(session, device, emitterHolder, identifier) : (device.type() == RecognizedDevice.PDH ? !this.addPowerHubEmitter(session, device, emitterHolder, identifier) : device.type() == RecognizedDevice.PH && !this.addPneumaticHubEmitter(session, device, emitterHolder, identifier)))) {
                return;
            }
        }
        if ((emitter = emitterHolder.getEmitter(identifier)) != null) {
            emitter.setFrameEnabled(state.index, state.enabled);
        }
    }

    private boolean addSparkEmitter(WebSocketSession session, FRCCanDevice device, DeviceManager.StatusFrameEmitterHolder emitterHolder, DeviceManager.FullDeviceIdentifier identifier) {
        SparkBase spark = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getSpark(device.id());
        if (spark == null) {
            return false;
        }
        emitterHolder.addSparkEmitterCallback(spark, identifier, this.createSparkCallback(session), this.createStopCallback(session, identifier));
        return true;
    }

    private boolean addServoHubEmitter(WebSocketSession session, FRCCanDevice device, DeviceManager.StatusFrameEmitterHolder emitterHolder, DeviceManager.FullDeviceIdentifier identifier) {
        ServoHub servoHub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getServoHub(device.id());
        if (servoHub == null) {
            return false;
        }
        emitterHolder.addServoHubEmitterCallback(servoHub, identifier, this.createServoHubCallback(session), this.createStopCallback(session, identifier));
        return true;
    }

    private boolean addPowerHubEmitter(WebSocketSession session, FRCCanDevice device, DeviceManager.StatusFrameEmitterHolder emitterHolder, DeviceManager.FullDeviceIdentifier identifier) {
        PowerHub powerHub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getPowerHub(device.id());
        if (powerHub == null) {
            return false;
        }
        this.deviceDaemon.doWithRawCanBridge(identifier.descriptor(), (bridge, bus) -> {
            emitterHolder.addPowerHubEmitterCallback(powerHub, identifier, this.createPowerHubCallback(session), this.createStopCallback(session, identifier), bridge, bus);
            return null;
        });
        return true;
    }

    private boolean addPneumaticHubEmitter(WebSocketSession session, FRCCanDevice device, DeviceManager.StatusFrameEmitterHolder emitterHolder, DeviceManager.FullDeviceIdentifier identifier) {
        PneumaticHub pneumaticHub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getPneumaticHub(device.id());
        if (pneumaticHub == null) {
            return false;
        }
        this.deviceDaemon.doWithRawCanBridge(identifier.descriptor(), (bridge, bus) -> {
            emitterHolder.addPneumaticHubEmitterCallback(pneumaticHub, identifier, this.createPneumaticHubCallback(session), this.createStopCallback(session, identifier));
            return null;
        });
        return true;
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        super.afterConnectionClosed(session, status);
        this.deviceDaemon.getDeviceManager().closeFrameEmitters(session.getId());
        String key = this.sessionIdToKeyMap.remove(session.getId());
        if (key != null) {
            this.sessions.remove(key);
        }
    }

    StatusFrameEmitter.OnStopCallback createStopCallback(WebSocketSession session, DeviceManager.FullDeviceIdentifier identifier) {
        return () -> {
            String key = this.sessionIdToKeyMap.get(session.getId());
            DeviceManager.StatusFrameEmitterHolder emitterHolder = this.deviceDaemon.getDeviceManager().getSparkStatusFrameEmitter(key);
            if (emitterHolder != null) {
                emitterHolder.stopEmitter(identifier);
            }
        };
    }

    SparkStatusFrameEmitter.StatusDataCallback createSparkCallback(WebSocketSession session) {
        ObjectMapper mapper = new ObjectMapper();
        return data -> {
            StatusFrameWebsocketHandler.throwIfClosed(session);
            try {
                String text = mapper.writeValueAsString((Object)data);
                TextMessage message = new TextMessage((CharSequence)text);
                StatusFrameWebsocketHandler.sendWebsocketTextMessage(session, message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendWebsocketTextMessage(WebSocketSession session, WebSocketMessage<?> message) throws IOException {
        WebSocketSession webSocketSession = session;
        synchronized (webSocketSession) {
            if (session.isOpen()) {
                session.sendMessage(message);
            }
        }
    }

    ServoHubStatusFrameEmitter.StatusDataCallback createServoHubCallback(WebSocketSession session) {
        ObjectMapper mapper = new ObjectMapper();
        return data -> {
            StatusFrameWebsocketHandler.throwIfClosed(session);
            try {
                String text = mapper.writeValueAsString((Object)data);
                TextMessage message = new TextMessage((CharSequence)text);
                session.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    PowerHubStatusEmitter.StatusDataCallback createPowerHubCallback(WebSocketSession session) {
        ObjectMapper mapper = new ObjectMapper();
        return data -> {
            StatusFrameWebsocketHandler.throwIfClosed(session);
            try {
                String text = mapper.writeValueAsString((Object)data);
                TextMessage message = new TextMessage((CharSequence)text);
                session.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    PneumaticHubStatusEmitter.StatusDataCallback createPneumaticHubCallback(WebSocketSession session) {
        ObjectMapper mapper = new ObjectMapper();
        return data -> {
            StatusFrameWebsocketHandler.throwIfClosed(session);
            try {
                String text = mapper.writeValueAsString((Object)data);
                TextMessage message = new TextMessage((CharSequence)text);
                session.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
    }

    private static void throwIfClosed(WebSocketSession session) {
        if (!session.isOpen()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    private static class FrameEnableCommand {
        private FrameEnabledState[] states;

        public void setStates(FrameEnabledState[] states) {
            this.states = states;
        }

        public FrameEnabledState[] getStates() {
            return this.states;
        }
    }

    private static class FrameEnabledState {
        private String descriptor;
        private UUID uuid;
        private int index;
        private boolean enabled;

        public String getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private record CreateKeyCommand(String key) {
    }
}

