/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.download;

public record Version(int major, int minor, int fix, int prerelease) {
    public boolean isAtLeast(Version other) {
        if (this.major != other.major) {
            return this.major > other.major;
        }
        if (this.minor != other.minor) {
            return this.minor > other.minor;
        }
        if (this.fix != other.fix) {
            return this.fix > other.fix;
        }
        return this.prerelease >= other.prerelease;
    }

    public boolean isGreaterThan(Version other) {
        return !this.isEqual(other) && this.isAtLeast(other);
    }

    public boolean isEqual(Version other) {
        return this.equals(other);
    }

    public boolean isStable() {
        return this.prerelease == 0;
    }

    public static Version parseVersion(long code) {
        int major = Math.toIntExact(code >> 24 & 0xFFL);
        int minor = Math.toIntExact(code >> 16 & 0xFFL);
        int fix = Math.toIntExact(code & 0xFFFFL);
        int prerelease = Math.toIntExact(code >> 32 & 0xFFFFL);
        return new Version(major, minor, fix, prerelease);
    }
}

