/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.download.db;

import com.revrobotics.revui.app.download.DownloadContext;
import com.revrobotics.revui.app.download.DownloadFile;
import com.revrobotics.revui.app.download.Version;
import com.revrobotics.revui.app.download.db.DownloadChannel;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import java.nio.file.Path;
import java.util.Set;

@Entity
public class DownloadModel {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String path;
    private String downloadUrl;
    private boolean isDownloaded;
    @Enumerated(value=EnumType.STRING)
    private DownloadContext context;
    private int major;
    private int minor;
    private int fix;
    private int prerelease;
    private String sha256;
    private String releaseNotes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="download_channel_id")})
    private Set<DownloadChannel> channels;

    public DownloadModel() {
    }

    public DownloadModel(Long id, String path, String downloadUrl, boolean isDownloaded, DownloadContext context, String sha256, String releaseNotes, Set<DownloadChannel> channels, int major, int minor, int fix, int prerelease) {
        this.id = id;
        this.path = path;
        this.downloadUrl = downloadUrl;
        this.isDownloaded = isDownloaded;
        this.context = context;
        this.major = major;
        this.minor = minor;
        this.fix = fix;
        this.prerelease = prerelease;
        this.sha256 = sha256;
        this.releaseNotes = releaseNotes;
        this.channels = channels;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public boolean isDownloaded() {
        return this.isDownloaded;
    }

    public void setDownloaded(boolean downloaded) {
        this.isDownloaded = downloaded;
    }

    public DownloadContext getContext() {
        return this.context;
    }

    public void setContext(DownloadContext context) {
        this.context = context;
    }

    public Set<DownloadChannel> getChannels() {
        return this.channels;
    }

    public void setChannels(Set<DownloadChannel> channels) {
        this.channels = channels;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getFix() {
        return this.fix;
    }

    public void setFix(int fix) {
        this.fix = fix;
    }

    public int getPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(int prerelease) {
        this.prerelease = prerelease;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public static DownloadFile toDownloadFile(DownloadModel model) {
        return new DownloadFile(model.id.intValue(), new Version(model.major, model.minor, model.fix, model.prerelease), model.context, Path.of(model.path, new String[0]), model.channels.stream().map(DownloadChannel::getName).toList(), model.isDownloaded);
    }
}

