/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.servohub.ServoHub;
import com.revrobotics.servohub.ServoHubLowLevel;
import java.util.UUID;

public class ServoHubStatusFrameEmitter
extends StatusFrameEmitter {
    private final ServoHub servoHub;
    private final StatusDataCallback statusDataCallback;
    private final String descriptor;
    private final UUID uuid;
    private final String messageName;

    public ServoHubStatusFrameEmitter(String descriptor, UUID uuid, ServoHub servoHub, StatusDataCallback statusDataCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
        super(onStopCallback, 5);
        this.servoHub = servoHub;
        this.statusDataCallback = statusDataCallback;
        this.descriptor = descriptor;
        this.uuid = uuid;
        this.messageName = "Servo Hub " + servoHub.getDeviceId();
    }

    private CommunicationMode toComMode(int mode) {
        if (mode == 1) {
            return CommunicationMode.RS485;
        }
        return CommunicationMode.CAN;
    }

    private Status0 getStatus0() {
        ServoHubLowLevel.PeriodicStatus0 frame = this.servoHub.getPeriodicStatus0();
        if (frame == null) {
            return null;
        }
        return new Status0(frame.voltage, frame.servoVoltage, frame.deviceCurrent, frame.primaryHeartbeatLock, frame.systemEnabled, this.toComMode(frame.communicationMode), frame.programmingEnabled, frame.activelyProgramming);
    }

    private Status1 getStatus1() {
        ServoHubLowLevel.PeriodicStatus1 frame = this.servoHub.getPeriodicStatus1();
        if (frame == null) {
            return null;
        }
        return new Status1(frame.regulatorPowerGoodFault, frame.brownout, frame.canWarning, frame.canBusOff, frame.hardwareFault, frame.firmwareFault, frame.hasReset, frame.channel0Overcurrent, frame.channel1Overcurrent, frame.channel2Overcurrent, frame.channel3Overcurrent, frame.channel4Overcurrent, frame.channel5Overcurrent, frame.stickyRegulatorPowerGoodFault, frame.stickyBrownout, frame.stickyCanWarning, frame.stickyCanBusOff, frame.stickyHardwareFault, frame.stickyFirmwareFault, frame.stickyHasReset, frame.stickyChannel0Overcurrent, frame.stickyChannel1Overcurrent, frame.stickyChannel2Overcurrent, frame.stickyChannel3Overcurrent, frame.stickyChannel4Overcurrent, frame.stickyChannel5Overcurrent);
    }

    private Status2 getStatus2() {
        ServoHubLowLevel.PeriodicStatus2 frame = this.servoHub.getPeriodicStatus2();
        if (frame == null) {
            return null;
        }
        return new Status2(frame.channel0PulseWidth, frame.channel1PulseWidth, frame.channel2PulseWidth, frame.channel0Enabled, frame.channel1Enabled, frame.channel2Enabled, frame.channel0OutOfRange, frame.channel1OutOfRange, frame.channel2OutOfRange);
    }

    private Status3 getStatus3() {
        ServoHubLowLevel.PeriodicStatus3 frame = this.servoHub.getPeriodicStatus3();
        if (frame == null) {
            return null;
        }
        return new Status3(frame.channel3PulseWidth, frame.channel4PulseWidth, frame.channel5PulseWidth, frame.channel3Enabled, frame.channel4Enabled, frame.channel5Enabled, frame.channel3OutOfRange, frame.channel4OutOfRange, frame.channel5OutOfRange);
    }

    private Status4 getStatus4() {
        ServoHubLowLevel.PeriodicStatus4 frame = this.servoHub.getPeriodicStatus4();
        if (frame == null) {
            return null;
        }
        return new Status4(frame.channel0Current, frame.channel1Current, frame.channel2Current, frame.channel3Current, frame.channel4Current, frame.channel5Current);
    }

    @Override
    public void runFrameEmitter() {
        try {
            Status1 servoHubStatus1 = null;
            Status2 servoHubStatus2 = null;
            Status3 servoHubStatus3 = null;
            Status4 servoHubStatus4 = null;
            if (this.frameEnabled[1]) {
                servoHubStatus1 = this.getStatus1();
            }
            if (this.frameEnabled[2]) {
                servoHubStatus2 = this.getStatus2();
            }
            if (this.frameEnabled[3]) {
                servoHubStatus3 = this.getStatus3();
            }
            if (this.frameEnabled[4]) {
                servoHubStatus4 = this.getStatus4();
            }
            Data statusData = new Data(this.getStatus0(), servoHubStatus1, servoHubStatus2, servoHubStatus3, servoHubStatus4);
            ServoHubStatusData data = new ServoHubStatusData(this.getTimestamp(), this.messageName, this.descriptor, this.uuid, statusData);
            if (this.statusDataCallback != null) {
                this.statusDataCallback.onServoHubStatusData(data);
            }
        }
        catch (IllegalStateException e) {
            this.stop();
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Attempted to access invalid status frame. Check for programming error");
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getThreadName() {
        return "ServoHubStatusFrameEmitter(" + this.servoHub.getDeviceId() + ")";
    }

    public static interface StatusDataCallback {
        public void onServoHubStatusData(ServoHubStatusData var1);
    }

    public static enum CommunicationMode {
        CAN,
        RS485;

    }

    public record Status0(double voltage, double servoVoltage, double deviceCurrent, boolean primaryHeartbeatLock, boolean systemEnabled, CommunicationMode mode, boolean programmingEnabled, boolean activelyProgramming) {
    }

    public record Status1(boolean regulatorPowerGoodFault, boolean brownout, boolean canWarning, boolean canBusOff, boolean hardwareFault, boolean firmwareFault, boolean hasReset, boolean channel0Overcurrent, boolean channel1Overcurrent, boolean channel2Overcurrent, boolean channel3Overcurrent, boolean channel4Overcurrent, boolean channel5Overcurrent, boolean stickyRegulatorPowerGoodFault, boolean stickyBrownout, boolean stickyCanWarning, boolean stickyCanBusOff, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyHasReset, boolean stickyChannel0Overcurrent, boolean stickyChannel1Overcurrent, boolean stickyChannel2Overcurrent, boolean stickyChannel3Overcurrent, boolean stickyChannel4Overcurrent, boolean stickyChannel5Overcurrent) {
    }

    public record Status2(double channel0PulseWidth, double channel1PulseWidth, double channel2PulseWidth, boolean channel0Enabled, boolean channel1Enabled, boolean channel2Enabled, boolean channel0OutOfRange, boolean channel1OutOfRange, boolean channel2OutOfRange) {
    }

    public record Status3(short channel3PulseWidth, short channel4PulseWidth, short channel5PulseWidth, boolean channel3Enabled, boolean channel4Enabled, boolean channel5Enabled, boolean channel3OutOfRange, boolean channel4OutOfRange, boolean channel5OutOfRange) {
    }

    public record Status4(double channel0Current, double channel1Current, double channel2Current, double channel3Current, double channel4Current, double channel5Current) {
    }

    public record Data(Status0 status0, Status1 status1, Status2 status2, Status3 status3, Status4 status4) {
    }

    public record ServoHubStatusData(double timestamp, String name, String descriptor, UUID uuid, Data data) {
    }
}

