/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkLowLevel;
import java.util.UUID;

public class SparkStatusFrameEmitter
extends StatusFrameEmitter {
    private final SparkBase spark;
    private final StatusDataCallback statusDataCallback;
    private final String descriptor;
    private final UUID uuid;
    private final String messageName;

    public SparkStatusFrameEmitter(String descriptor, UUID uuid, SparkBase spark, StatusDataCallback statusDataCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
        super(onStopCallback, 10);
        this.spark = spark;
        this.statusDataCallback = statusDataCallback;
        this.descriptor = descriptor;
        this.uuid = uuid;
        this.messageName = "SPARK " + spark.getDeviceId();
    }

    private SparkStatus0 getStatus0(SparkBase spark) {
        SparkLowLevel.PeriodicStatus0 frame = spark.getPeriodicStatus0();
        if (frame == null) {
            return null;
        }
        return new SparkStatus0(frame.appliedOutput, frame.voltage, frame.current, (byte)frame.motorTemperature, frame.hardForwardLimitReached, frame.hardReverseLimitReached, frame.softForwardLimitReached, frame.softReverseLimitReached, frame.inverted, frame.primaryHeartbeatLock);
    }

    private SparkStatus1 getStatus1(SparkBase spark) {
        SparkLowLevel.PeriodicStatus1 frame = spark.getPeriodicStatus1();
        if (frame == null) {
            return null;
        }
        return new SparkStatus1(frame.otherFault, frame.motorTypeFault, frame.sensorFault, frame.canFault, frame.temperatureFault, frame.drvFault, frame.escEepromFault, frame.firmwareFault, frame.brownoutWarning, frame.overcurrentWarning, frame.escEepromWarning, frame.extEepromWarning, frame.sensorWarning, frame.stallWarning, frame.hasResetWarning, frame.otherWarning, frame.otherStickyFault, frame.motorTypeStickyFault, frame.sensorStickyFault, frame.canStickyFault, frame.temperatureStickyFault, frame.drvStickyFault, frame.escEepromStickyFault, frame.firmwareStickyFault, frame.brownoutStickyWarning, frame.overcurrentStickyWarning, frame.escEepromStickyWarning, frame.extEepromStickyWarning, frame.sensorStickyWarning, frame.stallStickyWarning, frame.hasResetStickyWarning, frame.otherStickyWarning, frame.isFollower);
    }

    private SparkStatus2 getStatus2(SparkBase spark) {
        SparkLowLevel.PeriodicStatus2 frame = spark.getPeriodicStatus2();
        if (frame == null) {
            return null;
        }
        return new SparkStatus2(frame.primaryEncoderVelocity, frame.primaryEncoderPosition);
    }

    private SparkStatus3 getStatus3(SparkBase spark) {
        SparkLowLevel.PeriodicStatus3 frame = spark.getPeriodicStatus3();
        if (frame == null) {
            return null;
        }
        return new SparkStatus3(frame.analogVoltage, frame.analogVelocity, frame.analogPosition);
    }

    private SparkStatus4 getStatus4(SparkBase spark) {
        SparkLowLevel.PeriodicStatus4 frame = spark.getPeriodicStatus4();
        if (frame == null) {
            return null;
        }
        return new SparkStatus4(frame.externalOrAltEncoderVelocity, frame.externalOrAltEncoderPosition);
    }

    private SparkStatus5 getStatus5(SparkBase spark) {
        SparkLowLevel.PeriodicStatus5 frame = spark.getPeriodicStatus5();
        if (frame == null) {
            return null;
        }
        return new SparkStatus5(frame.dutyCycleEncoderVelocity, frame.dutyCycleEncoderPosition);
    }

    private SparkStatus6 getStatus6(SparkBase spark) {
        SparkLowLevel.PeriodicStatus6 frame = spark.getPeriodicStatus6();
        if (frame == null) {
            return null;
        }
        return new SparkStatus6(frame.unadjustedDutyCycle, frame.dutyCyclePeriod, frame.dutyCycleNoSignal);
    }

    private SparkStatus7 getStatus7(SparkBase spark) {
        SparkLowLevel.PeriodicStatus7 frame = spark.getPeriodicStatus7();
        if (frame == null) {
            return null;
        }
        return new SparkStatus7(frame.iAccumulation);
    }

    private SparkStatus8 getStatus8(SparkBase spark) {
        SparkLowLevel.PeriodicStatus8 frame = spark.getPeriodicStatus8();
        if (frame == null) {
            return null;
        }
        return new SparkStatus8(frame.setpoint, frame.isAtSetpoint, frame.selectedPidSlot);
    }

    private SparkStatus9 getStatus9(SparkBase spark) {
        SparkLowLevel.PeriodicStatus9 frame = spark.getPeriodicStatus9();
        if (frame == null) {
            return null;
        }
        return new SparkStatus9(frame.maxmotionSetpointVelocity, frame.maxmotionSetpointPosition);
    }

    @Override
    public void runFrameEmitter() {
        try {
            SparkStatus1 sparkStatus1 = null;
            SparkStatus2 sparkStatus2 = null;
            SparkStatus3 sparkStatus3 = null;
            SparkStatus4 sparkStatus4 = null;
            SparkStatus5 sparkStatus5 = null;
            SparkStatus6 sparkStatus6 = null;
            SparkStatus7 sparkStatus7 = null;
            SparkStatus8 sparkStatus8 = null;
            SparkStatus9 sparkStatus9 = null;
            if (this.frameEnabled[1]) {
                sparkStatus1 = this.getStatus1(this.spark);
            }
            if (this.frameEnabled[2]) {
                sparkStatus2 = this.getStatus2(this.spark);
            }
            if (this.frameEnabled[3]) {
                sparkStatus3 = this.getStatus3(this.spark);
            }
            if (this.frameEnabled[4]) {
                sparkStatus4 = this.getStatus4(this.spark);
            }
            if (this.frameEnabled[5]) {
                sparkStatus5 = this.getStatus5(this.spark);
            }
            if (this.frameEnabled[6]) {
                sparkStatus6 = this.getStatus6(this.spark);
            }
            if (this.frameEnabled[7]) {
                sparkStatus7 = this.getStatus7(this.spark);
            }
            if (this.frameEnabled[8]) {
                sparkStatus8 = this.getStatus8(this.spark);
            }
            if (this.frameEnabled[9]) {
                sparkStatus9 = this.getStatus9(this.spark);
            }
            Data statusData = new Data(this.getStatus0(this.spark), sparkStatus1, sparkStatus2, sparkStatus3, sparkStatus4, sparkStatus5, sparkStatus6, sparkStatus7, sparkStatus8, sparkStatus9);
            SparkStatusData data = new SparkStatusData(this.getTimestamp(), this.messageName, this.descriptor, this.uuid, statusData);
            if (this.statusDataCallback != null) {
                this.statusDataCallback.onSparkFrameData(data);
            }
        }
        catch (IllegalStateException e) {
            this.stop();
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Attempted to access invalid status frame. Check for programming error");
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getThreadName() {
        return "SparkStatusFrameEmitter(" + this.spark.getDeviceId() + ")";
    }

    public static interface StatusDataCallback {
        public void onSparkFrameData(SparkStatusData var1);
    }

    public record SparkStatus0(double appliedOutput, double voltage, double current, byte motorTemp, boolean hardLimitReached, boolean hardReverseLimitReached, boolean softLimitReached, boolean softReverseLimitReached, boolean inverted, boolean primaryHeartbeatLock) {
    }

    public record SparkStatus1(boolean otherFault, boolean motorTypeFault, boolean sensorFault, boolean canFault, boolean temperatureFault, boolean drvFault, boolean escEepromFault, boolean firmwareFault, boolean brownoutWarning, boolean overcurrentWarning, boolean escEepromWarning, boolean extEepromWarning, boolean sensorWarning, boolean stallWarning, boolean hasResetWarning, boolean otherWarning, boolean otherStickyFault, boolean motorTypeStickyFault, boolean sensorStickyFault, boolean canStickyFault, boolean temperatureStickyFault, boolean drvStickyFault, boolean escEepromStickyFault, boolean firmwareStickyFault, boolean brownoutStickyWarning, boolean overcurrentStickyWarning, boolean escEepromStickyWarning, boolean extEepromStickyWarning, boolean sensorStickyWarning, boolean stallStickyWarning, boolean hasResetStickyWarning, boolean otherStickyWarning, boolean isFollower) {
    }

    public record SparkStatus2(double primaryEncoderVelocity, double primaryEncoderPosition) {
    }

    public record SparkStatus3(double analogVoltage, double analogVelocity, double analogPosition) {
    }

    public record SparkStatus4(double externalVelocity, double externalPosition) {
    }

    public record SparkStatus5(double dutyCycleVelocity, double dutyCyclePosition) {
    }

    public record SparkStatus6(double rawDutyCycle, double dutyCyclePeriod, boolean dutyCycleNoSignal) {
    }

    public record SparkStatus7(double iAccum) {
    }

    public record SparkStatus8(double setpoint, boolean isAtSetpoint, int selectedPidSlot) {
    }

    public record SparkStatus9(double maxMotionSetpointVelocity, double maxMotionSetpointPosition) {
    }

    public record Data(SparkStatus0 status0, SparkStatus1 status1, SparkStatus2 status2, SparkStatus3 status3, SparkStatus4 status4, SparkStatus5 status5, SparkStatus6 status6, SparkStatus7 status7, SparkStatus8 status8, SparkStatus9 status9) {
    }

    public record SparkStatusData(double timestamp, String name, String descriptor, UUID uuid, Data data) {
    }
}

