/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CompositeIterator;

class CompositeCollection<E>
implements Collection<E> {
    private final Collection<E> first;
    private final Collection<E> second;

    CompositeCollection(Collection<E> first, Collection<E> second) {
        Assert.notNull(first, "First must not be null");
        Assert.notNull(second, "Second must not be null");
        this.first = first;
        this.second = second;
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.first.contains(o)) {
            return true;
        }
        return this.second.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        CompositeIterator<E> iterator = new CompositeIterator<E>();
        iterator.add(this.first.iterator());
        iterator.add(this.second.iterator());
        return iterator;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Object[] firstArray = this.first.toArray();
        Object[] secondArray = this.second.toArray();
        System.arraycopy(firstArray, 0, result, 0, firstArray.length);
        System.arraycopy(secondArray, 0, result, firstArray.length, secondArray.length);
        return result;
    }

    @Override
    public <T> @Nullable T[] toArray(@Nullable T[] a) {
        int size = this.size();
        @Nullable Object[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        int idx = 0;
        for (E e : this) {
            result[idx++] = e;
        }
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        boolean firstResult = this.first.remove(o);
        boolean secondResult = this.second.remove(o);
        return firstResult || secondResult;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean firstResult = this.first.removeAll(c);
        boolean secondResult = this.second.removeAll(c);
        return firstResult || secondResult;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean firstResult = this.first.retainAll(c);
        boolean secondResult = this.second.retainAll(c);
        return firstResult || secondResult;
    }

    @Override
    public void clear() {
        this.first.clear();
        this.second.clear();
    }
}

