/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.scheduling;

import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.FixedDelayTask;
import org.springframework.scheduling.config.FixedRateTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskHolder;
import org.springframework.scheduling.config.TaskExecutionOutcome;
import org.springframework.scheduling.config.TriggerTask;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.LinkedMultiValueMap;

@Endpoint(id="scheduledtasks")
@ImportRuntimeHints(value={ScheduledTasksEndpointRuntimeHints.class})
public class ScheduledTasksEndpoint {
    private final Collection<ScheduledTaskHolder> scheduledTaskHolders;

    public ScheduledTasksEndpoint(Collection<ScheduledTaskHolder> scheduledTaskHolders) {
        this.scheduledTaskHolders = scheduledTaskHolders;
    }

    @ReadOperation
    public ScheduledTasksDescriptor scheduledTasks() {
        LinkedMultiValueMap descriptionsByType = new LinkedMultiValueMap();
        for (ScheduledTaskHolder holder : this.scheduledTaskHolders) {
            for (ScheduledTask scheduledTask : holder.getScheduledTasks()) {
                TaskType taskType = TaskType.forTask(scheduledTask);
                if (taskType == null) continue;
                TaskDescriptor descriptor = taskType.createDescriptor(scheduledTask);
                descriptionsByType.add((Object)descriptor.getType(), (Object)descriptor);
            }
        }
        return new ScheduledTasksDescriptor((Map<TaskType, List<TaskDescriptor>>)descriptionsByType);
    }

    private static enum TaskType {
        CRON(CronTask.class, scheduledTask -> new CronTaskDescriptor((ScheduledTask)scheduledTask, (CronTask)scheduledTask.getTask())),
        FIXED_DELAY(FixedDelayTask.class, scheduledTask -> new FixedDelayTaskDescriptor((ScheduledTask)scheduledTask, (FixedDelayTask)scheduledTask.getTask())),
        FIXED_RATE(FixedRateTask.class, scheduledTask -> new FixedRateTaskDescriptor((ScheduledTask)scheduledTask, (FixedRateTask)scheduledTask.getTask())),
        CUSTOM_TRIGGER(TriggerTask.class, TaskType::describeTriggerTask);

        final Class<?> taskClass;
        final Function<ScheduledTask, TaskDescriptor> describer;

        private TaskType(Class<?> taskClass, Function<ScheduledTask, TaskDescriptor> describer) {
            this.taskClass = taskClass;
            this.describer = describer;
        }

        static @Nullable TaskType forTask(ScheduledTask scheduledTask) {
            for (TaskType taskType : TaskType.values()) {
                if (!taskType.taskClass.isInstance(scheduledTask.getTask())) continue;
                return taskType;
            }
            return null;
        }

        TaskDescriptor createDescriptor(ScheduledTask scheduledTask) {
            return this.describer.apply(scheduledTask);
        }

        private static TaskDescriptor describeTriggerTask(ScheduledTask scheduledTask) {
            TriggerTask triggerTask = (TriggerTask)scheduledTask.getTask();
            Trigger trigger = triggerTask.getTrigger();
            if (trigger instanceof CronTrigger) {
                CronTrigger cronTrigger = (CronTrigger)trigger;
                return new CronTaskDescriptor(scheduledTask, triggerTask, cronTrigger);
            }
            if (trigger instanceof PeriodicTrigger) {
                PeriodicTrigger periodicTrigger = (PeriodicTrigger)trigger;
                if (periodicTrigger.isFixedRate()) {
                    return new FixedRateTaskDescriptor(scheduledTask, triggerTask, periodicTrigger);
                }
                return new FixedDelayTaskDescriptor(scheduledTask, triggerTask, periodicTrigger);
            }
            return new CustomTriggerTaskDescriptor(scheduledTask);
        }
    }

    public static abstract class TaskDescriptor {
        private final TaskType type;
        private final ScheduledTask scheduledTask;
        private final RunnableDescriptor runnable;

        protected TaskDescriptor(ScheduledTask scheduledTask, TaskType type) {
            this.scheduledTask = scheduledTask;
            this.type = type;
            this.runnable = new RunnableDescriptor(scheduledTask.getTask().getRunnable());
        }

        private TaskType getType() {
            return this.type;
        }

        public final RunnableDescriptor getRunnable() {
            return this.runnable;
        }

        public final @Nullable NextExecution getNextExecution() {
            Instant nextExecution = this.scheduledTask.nextExecution();
            if (nextExecution != null) {
                return new NextExecution(nextExecution);
            }
            return null;
        }

        public final @Nullable LastExecution getLastExecution() {
            TaskExecutionOutcome lastExecutionOutcome = this.scheduledTask.getTask().getLastExecutionOutcome();
            if (lastExecutionOutcome.status() != TaskExecutionOutcome.Status.NONE) {
                return new LastExecution(lastExecutionOutcome);
            }
            return null;
        }
    }

    public static final class ScheduledTasksDescriptor
    implements OperationResponseBody {
        private final List<TaskDescriptor> cron;
        private final List<TaskDescriptor> fixedDelay;
        private final List<TaskDescriptor> fixedRate;
        private final List<TaskDescriptor> custom;

        private ScheduledTasksDescriptor(Map<TaskType, List<TaskDescriptor>> descriptionsByType) {
            this.cron = descriptionsByType.getOrDefault((Object)TaskType.CRON, Collections.emptyList());
            this.fixedDelay = descriptionsByType.getOrDefault((Object)TaskType.FIXED_DELAY, Collections.emptyList());
            this.fixedRate = descriptionsByType.getOrDefault((Object)TaskType.FIXED_RATE, Collections.emptyList());
            this.custom = descriptionsByType.getOrDefault((Object)TaskType.CUSTOM_TRIGGER, Collections.emptyList());
        }

        public List<TaskDescriptor> getCron() {
            return this.cron;
        }

        public List<TaskDescriptor> getFixedDelay() {
            return this.fixedDelay;
        }

        public List<TaskDescriptor> getFixedRate() {
            return this.fixedRate;
        }

        public List<TaskDescriptor> getCustom() {
            return this.custom;
        }
    }

    static class ScheduledTasksEndpointRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        ScheduledTasksEndpointRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{FixedRateTaskDescriptor.class, FixedDelayTaskDescriptor.class, CronTaskDescriptor.class, CustomTriggerTaskDescriptor.class});
        }
    }

    public static final class RunnableDescriptor {
        private final String target;

        private RunnableDescriptor(Runnable runnable) {
            this.target = runnable.toString();
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static final class CustomTriggerTaskDescriptor
    extends TaskDescriptor {
        private final String trigger;

        private CustomTriggerTaskDescriptor(ScheduledTask scheduledTask) {
            super(scheduledTask, TaskType.CUSTOM_TRIGGER);
            TriggerTask triggerTask = (TriggerTask)scheduledTask.getTask();
            this.trigger = triggerTask.getTrigger().toString();
        }

        public String getTrigger() {
            return this.trigger;
        }
    }

    public static final class CronTaskDescriptor
    extends TaskDescriptor {
        private final String expression;

        private CronTaskDescriptor(ScheduledTask scheduledTask, CronTask cronTask) {
            super(scheduledTask, TaskType.CRON);
            this.expression = cronTask.getExpression();
        }

        private CronTaskDescriptor(ScheduledTask scheduledTask, TriggerTask triggerTask, CronTrigger trigger) {
            super(scheduledTask, TaskType.CRON);
            this.expression = trigger.getExpression();
        }

        public String getExpression() {
            return this.expression;
        }
    }

    public static final class FixedRateTaskDescriptor
    extends IntervalTaskDescriptor {
        private FixedRateTaskDescriptor(ScheduledTask scheduledTask, FixedRateTask task) {
            super(scheduledTask, TaskType.FIXED_RATE, (IntervalTask)task);
        }

        private FixedRateTaskDescriptor(ScheduledTask scheduledTask, TriggerTask task, PeriodicTrigger trigger) {
            super(scheduledTask, TaskType.FIXED_RATE, task, trigger);
        }
    }

    public static final class FixedDelayTaskDescriptor
    extends IntervalTaskDescriptor {
        private FixedDelayTaskDescriptor(ScheduledTask scheduledTask, FixedDelayTask task) {
            super(scheduledTask, TaskType.FIXED_DELAY, (IntervalTask)task);
        }

        private FixedDelayTaskDescriptor(ScheduledTask scheduledTask, TriggerTask task, PeriodicTrigger trigger) {
            super(scheduledTask, TaskType.FIXED_DELAY, task, trigger);
        }
    }

    public static class IntervalTaskDescriptor
    extends TaskDescriptor {
        private final long initialDelay;
        private final long interval;

        protected IntervalTaskDescriptor(ScheduledTask scheduledTask, TaskType type, IntervalTask intervalTask) {
            super(scheduledTask, type);
            this.initialDelay = intervalTask.getInitialDelayDuration().toMillis();
            this.interval = intervalTask.getIntervalDuration().toMillis();
        }

        protected IntervalTaskDescriptor(ScheduledTask scheduledTask, TaskType type, TriggerTask task, PeriodicTrigger trigger) {
            super(scheduledTask, type);
            Duration initialDelayDuration = trigger.getInitialDelayDuration();
            this.initialDelay = initialDelayDuration != null ? initialDelayDuration.toMillis() : 0L;
            this.interval = trigger.getPeriodDuration().toMillis();
        }

        public long getInitialDelay() {
            return this.initialDelay;
        }

        public long getInterval() {
            return this.interval;
        }
    }

    public static final class ExceptionInfo {
        private final Throwable throwable;

        private ExceptionInfo(Throwable throwable) {
            this.throwable = throwable;
        }

        public String getType() {
            return this.throwable.getClass().getName();
        }

        public @Nullable String getMessage() {
            return this.throwable.getMessage();
        }
    }

    public static final class LastExecution {
        private final TaskExecutionOutcome lastExecutionOutcome;

        private LastExecution(TaskExecutionOutcome lastExecutionOutcome) {
            this.lastExecutionOutcome = lastExecutionOutcome;
        }

        public TaskExecutionOutcome.Status getStatus() {
            return this.lastExecutionOutcome.status();
        }

        public @Nullable Instant getTime() {
            return this.lastExecutionOutcome.executionTime();
        }

        public @Nullable ExceptionInfo getException() {
            Throwable throwable = this.lastExecutionOutcome.throwable();
            if (throwable != null) {
                return new ExceptionInfo(throwable);
            }
            return null;
        }
    }

    public static final class NextExecution {
        private final Instant time;

        public NextExecution(Instant time) {
            this.time = time;
        }

        public Instant getTime() {
            return this.time;
        }
    }
}

