/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.devices;

import com.revrobotics.CanFrameUtils;
import com.revrobotics.can.spec.PneumaticHubCanSpec;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;

public class PneumaticHub {
    private static final int NUM_ATTEMPTS = 3;
    private final int id;
    private final CanBridge bridge;
    private final CanBus bus;
    private final CanFrameUtils utils;
    private final int[] channelStates = new int[15];

    public PneumaticHub(CanBridge bridge, CanBus bus, int id) {
        this.id = id;
        this.bridge = bridge;
        this.bus = bus;
        this.utils = new CanFrameUtils(bridge, bus);
    }

    public int getDeviceId() {
        return this.id;
    }

    public Status0 getStatus0() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 151328768 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PneumaticHubCanSpec.Status0 unpacked = PneumaticHubCanSpec.status0Unpack(frame.data());
        return new Status0(unpacked.channel0On(), unpacked.channel1On(), unpacked.channel2On(), unpacked.channel3On(), unpacked.channel4On(), unpacked.channel5On(), unpacked.channel6On(), unpacked.channel7On(), unpacked.channel8On(), unpacked.channel9On(), unpacked.channel10On(), unpacked.channel11On(), unpacked.channel12On(), unpacked.channel13On(), unpacked.channel14On(), unpacked.channel15On(), PneumaticHubCanSpec.status0AnalogChannel0Decode(unpacked.analogChannel0()), PneumaticHubCanSpec.status0AnalogChannel1Decode(unpacked.analogChannel1()), unpacked.digitalSensor(), unpacked.brownoutFault(), unpacked.compressorOvercurrentFault(), unpacked.compressorOpenFault(), unpacked.solenoidOvercurrentFault(), unpacked.cANWarningFault(), unpacked.hardwareFault(), unpacked.channel0Fault(), unpacked.channel1Fault(), unpacked.channel2Fault(), unpacked.channel3Fault(), unpacked.channel4Fault(), unpacked.channel5Fault(), unpacked.channel6Fault(), unpacked.channel7Fault(), unpacked.channel8Fault(), unpacked.channel9Fault(), unpacked.channel10Fault(), unpacked.channel11Fault(), unpacked.channel12Fault(), unpacked.channel13Fault(), unpacked.channel14Fault(), unpacked.channel15Fault(), unpacked.compressorOn(), unpacked.systemEnabled(), unpacked.roborioPresent(), unpacked.compressorConfig());
    }

    public Status1 getStatus1() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 151328832 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PneumaticHubCanSpec.Status1 unpacked = PneumaticHubCanSpec.status1Unpack(frame.data());
        return new Status1(PneumaticHubCanSpec.status1VBusDecode(unpacked.vBus()), PneumaticHubCanSpec.status1SolenoidVoltageDecode(unpacked.solenoidVoltage()), PneumaticHubCanSpec.status1CompressorCurrentDecode(unpacked.compressorCurrent()), PneumaticHubCanSpec.status1SolenoidCurrentDecode(unpacked.solenoidCurrent()), unpacked.stickyBrownoutFault(), unpacked.stickyCompressorOCFault(), unpacked.stickyCompressorOpenFault(), unpacked.stickySolenoidOCFault(), unpacked.stickyCANWarningFault(), unpacked.stickyCANBusOffFault(), unpacked.stickyHardwareFault(), unpacked.stickyFirmwareFault(), unpacked.stickyHasReset(), PneumaticHubCanSpec.status1SupplyVoltage5VDecode(unpacked.supplyVoltage5V()));
    }

    public void identify() {
        byte[] data = new byte[]{};
        CanMessage message = CanMessage.createClassic((int)(151330176 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, message);
    }

    public void setCanId(int newId) {
        byte[] data = new byte[]{(byte)newId};
        CanMessage frame = CanMessage.createClassic((int)(151355264 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, frame);
    }

    public void clearFaults() {
        byte[] data = new byte[]{};
        CanMessage frame = CanMessage.createClassic((int)(151329664 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, frame);
    }

    public void writeChannel(int channel, int state) {
        this.channelStates[channel] = state;
        this.writeChannels();
    }

    private void writeChannels() {
        byte[] data = new byte[4];
        for (int i = 0; i < this.channelStates.length; ++i) {
            int state = this.channelStates[i] & 3;
            int byteIndex = i / 4;
            int indexWithinByte = i % 4;
            int n = byteIndex;
            data[n] = (byte)(data[n] | (byte)(state << indexWithinByte * 2));
        }
        CanMessage message = CanMessage.createClassic((int)(151325696 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, message);
    }

    public void pulseChannels(byte[] channels, int durationMs) {
        byte[] data = new byte[4];
        for (byte b : channels) {
            int channel = b & 0xFF;
            int byteIndex = channel / 8;
            int indexWithinByte = channel % 8;
            int n = byteIndex;
            data[n] = (byte)(data[n] | (byte)(1 << indexWithinByte));
        }
        data[2] = (byte)durationMs;
        data[3] = (byte)(durationMs >> 8);
        CanMessage message = CanMessage.createClassic((int)(151325760 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, message);
    }

    public Version getVersion() {
        for (int i = 0; i < 3; ++i) {
            Version result = this.getVersionOrNull();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Version getVersionOrNull() {
        byte[] data = new byte[8];
        CanMessage message = CanMessage.createRtr((int)(151332352 + this.id), (byte[])data);
        CanMessage response = this.utils.sendAndAwaitResponse(message, message.messageId(), 1000);
        if (response == null) {
            return null;
        }
        PneumaticHubCanSpec.GetVersion version = PneumaticHubCanSpec.getVersionUnpack(response.data());
        return new Version(version.firmwareYear(), version.firmwareMinor(), version.firmwareFix(), 0);
    }

    public static boolean checkIfUsbBridge(CanBridge bridge, CanBus bus, int deviceId) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        byte[] data = new byte[0];
        CanMessage message = CanMessage.createRtr((int)(151334080 + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, message.messageId(), 500);
        return response != null && response.data().length == 4;
    }

    public void enterDfuBootloader() {
        int messageId = 151356288 + this.id;
        byte[] data = new byte[]{17, -33, -83, 16};
        CanMessage message = CanMessage.createClassic((int)messageId, (byte[])data);
        for (int i = 0; i < 3; ++i) {
            this.bridge.sendMessage(this.bus, message);
        }
    }

    public record Status0(boolean channel0On, boolean channel1On, boolean channel2On, boolean channel3On, boolean channel4On, boolean channel5On, boolean channel6On, boolean channel7On, boolean channel8On, boolean channel9On, boolean channel10On, boolean channel11On, boolean channel12On, boolean channel13On, boolean channel14On, boolean channel15On, double analogChannel0, double analogChannel1, boolean digitalSensor, boolean brownoutFault, boolean compressorOvercurrentFault, boolean compressorOpenFault, boolean solenoidOvercurrentFault, boolean cANWarningFault, boolean hardwareFault, boolean channel0Fault, boolean channel1Fault, boolean channel2Fault, boolean channel3Fault, boolean channel4Fault, boolean channel5Fault, boolean channel6Fault, boolean channel7Fault, boolean channel8Fault, boolean channel9Fault, boolean channel10Fault, boolean channel11Fault, boolean channel12Fault, boolean channel13Fault, boolean channel14Fault, boolean channel15Fault, boolean compressorOn, boolean systemEnabled, boolean roborioPresent, int compressorConfig) {
    }

    public record Status1(double vBus, double solenoidVoltage, double compressorCurrent, double solenoidCurrent, boolean stickyBrownoutFault, boolean stickyCompressorOCFault, boolean stickyCompressorOpenFault, boolean stickySolenoidOCFault, boolean stickyCANWarningFault, boolean stickyCANBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyHasReset, double supplyVoltage5V) {
    }

    public record Version(int major, int minor, int fix, int prerelease) {
    }
}

