/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub;

import com.revrobotics.REVLibError;
import com.revrobotics.jni.CANServoHubJNI;
import com.revrobotics.servohub.ServoHub;

public class ServoChannel {
    public static final int kNumServoChannels = 6;
    private ChannelId channelId;
    private final ServoHub servoHub;

    ServoChannel(ChannelId channelId, ServoHub device) {
        this.channelId = channelId;
        this.servoHub = device;
    }

    public ChannelId getChannelId() {
        this.servoHub.throwIfClosed();
        return this.channelId;
    }

    public int getPulseWidth() {
        this.servoHub.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetChannelPulseWidth(this.servoHub.servoHubHandle, this.channelId.value);
    }

    public boolean isEnabled() {
        this.servoHub.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetChannelEnabled(this.servoHub.servoHubHandle, this.channelId.value);
    }

    public double getCurrent() {
        this.servoHub.throwIfClosed();
        return CANServoHubJNI.c_ServoHub_GetChannelCurrent(this.servoHub.servoHubHandle, this.channelId.value);
    }

    public REVLibError setPulseWidth(int pulseWidth_us) {
        this.servoHub.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_SetChannelPulseWidth(this.servoHub.servoHubHandle, this.channelId.value, pulseWidth_us));
    }

    public REVLibError setEnabled(boolean enabled) {
        this.servoHub.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_SetChannelEnabled(this.servoHub.servoHubHandle, this.channelId.value, enabled));
    }

    public REVLibError setPowered(boolean powered) {
        this.servoHub.throwIfClosed();
        return REVLibError.fromInt(CANServoHubJNI.c_ServoHub_SetChannelPowered(this.servoHub.servoHubHandle, this.channelId.value, powered));
    }

    public static enum ChannelId {
        kChannelId0(0),
        kChannelId1(1),
        kChannelId2(2),
        kChannelId3(3),
        kChannelId4(4),
        kChannelId5(5);

        public final int value;

        private ChannelId(int value) {
            this.value = value;
        }

        public static ChannelId fromInt(int value) {
            switch (value) {
                case 0: {
                    return kChannelId0;
                }
                case 1: {
                    return kChannelId1;
                }
                case 2: {
                    return kChannelId2;
                }
                case 3: {
                    return kChannelId3;
                }
                case 4: {
                    return kChannelId4;
                }
                case 5: {
                    return kChannelId5;
                }
            }
            return kChannelId0;
        }
    }
}

