/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.mvc")
public class WebMvcProperties {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DefaultMessageCodesResolver.Format messageCodesResolverFormat;
    private final Format format = new Format();
    private boolean dispatchTraceRequest;
    private boolean dispatchOptionsRequest = true;
    private boolean publishRequestHandledEvents = true;
    private boolean logRequestDetails;
    private boolean logResolvedException;
    private String staticPathPattern = "/**";
    private String webjarsPathPattern = "/webjars/**";
    private final Async async = new Async();
    private final Servlet servlet = new Servlet();
    private final View view = new View();
    private final Contentnegotiation contentnegotiation = new Contentnegotiation();
    private final Pathmatch pathmatch = new Pathmatch();
    private final Problemdetails problemdetails = new Problemdetails();
    private final Apiversion apiversion = new Apiversion();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DefaultMessageCodesResolver.Format getMessageCodesResolverFormat() {
        return this.messageCodesResolverFormat;
    }

    public void setMessageCodesResolverFormat(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DefaultMessageCodesResolver.Format messageCodesResolverFormat) {
        this.messageCodesResolverFormat = messageCodesResolverFormat;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isPublishRequestHandledEvents() {
        return this.publishRequestHandledEvents;
    }

    public void setPublishRequestHandledEvents(boolean publishRequestHandledEvents) {
        this.publishRequestHandledEvents = publishRequestHandledEvents;
    }

    public boolean isLogRequestDetails() {
        return this.logRequestDetails;
    }

    public void setLogRequestDetails(boolean logRequestDetails) {
        this.logRequestDetails = logRequestDetails;
    }

    public boolean isLogResolvedException() {
        return this.logResolvedException;
    }

    public void setLogResolvedException(boolean logResolvedException) {
        this.logResolvedException = logResolvedException;
    }

    public boolean isDispatchOptionsRequest() {
        return this.dispatchOptionsRequest;
    }

    public void setDispatchOptionsRequest(boolean dispatchOptionsRequest) {
        this.dispatchOptionsRequest = dispatchOptionsRequest;
    }

    public boolean isDispatchTraceRequest() {
        return this.dispatchTraceRequest;
    }

    public void setDispatchTraceRequest(boolean dispatchTraceRequest) {
        this.dispatchTraceRequest = dispatchTraceRequest;
    }

    public String getStaticPathPattern() {
        return this.staticPathPattern;
    }

    public void setStaticPathPattern(String staticPathPattern) {
        this.staticPathPattern = staticPathPattern;
    }

    public String getWebjarsPathPattern() {
        return this.webjarsPathPattern;
    }

    public void setWebjarsPathPattern(String webjarsPathPattern) {
        this.webjarsPathPattern = webjarsPathPattern;
    }

    public Async getAsync() {
        return this.async;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public View getView() {
        return this.view;
    }

    public Contentnegotiation getContentnegotiation() {
        return this.contentnegotiation;
    }

    public Pathmatch getPathmatch() {
        return this.pathmatch;
    }

    public Problemdetails getProblemdetails() {
        return this.problemdetails;
    }

    public Apiversion getApiversion() {
        return this.apiversion;
    }

    public static class Format {
        private @Nullable String date;
        private @Nullable String time;
        private @Nullable String dateTime;

        public @Nullable String getDate() {
            return this.date;
        }

        public void setDate(@Nullable String date) {
            this.date = date;
        }

        public @Nullable String getTime() {
            return this.time;
        }

        public void setTime(@Nullable String time) {
            this.time = time;
        }

        public @Nullable String getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(@Nullable String dateTime) {
            this.dateTime = dateTime;
        }
    }

    public static class Async {
        private @Nullable Duration requestTimeout;

        public @Nullable Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(@Nullable Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }
    }

    public static class Servlet {
        private String path = "/";
        private int loadOnStartup = -1;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            Assert.notNull((Object)path, (String)"'path' must not be null");
            Assert.isTrue((!path.contains("*") ? 1 : 0) != 0, (String)"'path' must not contain wildcards");
            this.path = path;
        }

        public int getLoadOnStartup() {
            return this.loadOnStartup;
        }

        public void setLoadOnStartup(int loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
        }

        public String getServletMapping() {
            if (this.path.isEmpty() || this.path.equals("/")) {
                return "/";
            }
            if (this.path.endsWith("/")) {
                return this.path + "*";
            }
            return this.path + "/*";
        }

        public String getPath(String path) {
            String prefix = this.getServletPrefix();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return prefix + (String)path;
        }

        public String getServletPrefix() {
            String result = this.path;
            int index = result.indexOf(42);
            if (index != -1) {
                result = result.substring(0, index);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
    }

    public static class View {
        private @Nullable String prefix;
        private @Nullable String suffix;

        public @Nullable String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(@Nullable String prefix) {
            this.prefix = prefix;
        }

        public @Nullable String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(@Nullable String suffix) {
            this.suffix = suffix;
        }
    }

    public static class Contentnegotiation {
        private boolean favorParameter;
        private @Nullable String parameterName;
        private Map<String, MediaType> mediaTypes = new LinkedHashMap<String, MediaType>();
        private List<MediaType> defaultContentTypes = new ArrayList<MediaType>();

        public boolean isFavorParameter() {
            return this.favorParameter;
        }

        public void setFavorParameter(boolean favorParameter) {
            this.favorParameter = favorParameter;
        }

        public @Nullable String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(@Nullable String parameterName) {
            this.parameterName = parameterName;
        }

        public Map<String, MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        public void setMediaTypes(Map<String, MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }

        public List<MediaType> getDefaultContentTypes() {
            return this.defaultContentTypes;
        }

        public void setDefaultContentTypes(List<MediaType> defaultContentTypes) {
            this.defaultContentTypes = defaultContentTypes;
        }
    }

    public static class Pathmatch {
        private MatchingStrategy matchingStrategy = MatchingStrategy.PATH_PATTERN_PARSER;

        public MatchingStrategy getMatchingStrategy() {
            return this.matchingStrategy;
        }

        public void setMatchingStrategy(MatchingStrategy matchingStrategy) {
            this.matchingStrategy = matchingStrategy;
        }
    }

    public static class Problemdetails {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Apiversion {
        private @Nullable Boolean required;
        @Name(value="default")
        private @Nullable String defaultVersion;
        private @Nullable List<String> supported;
        private @Nullable Boolean detectSupported;
        private final Use use = new Use();

        public @Nullable Boolean getRequired() {
            return this.required;
        }

        public void setRequired(@Nullable Boolean required) {
            this.required = required;
        }

        public @Nullable String getDefaultVersion() {
            return this.defaultVersion;
        }

        public void setDefaultVersion(@Nullable String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public @Nullable List<String> getSupported() {
            return this.supported;
        }

        public void setSupported(@Nullable List<String> supported) {
            this.supported = supported;
        }

        public @Nullable Boolean getDetectSupported() {
            return this.detectSupported;
        }

        public void setDetectSupported(@Nullable Boolean detectSupported) {
            this.detectSupported = detectSupported;
        }

        public Use getUse() {
            return this.use;
        }

        public static class Use {
            private @Nullable String header;
            private @Nullable String queryParameter;
            private @Nullable Integer pathSegment;
            private Map<MediaType, String> mediaTypeParameter = new LinkedHashMap<MediaType, String>();

            public @Nullable String getHeader() {
                return this.header;
            }

            public void setHeader(@Nullable String header) {
                this.header = header;
            }

            public @Nullable String getQueryParameter() {
                return this.queryParameter;
            }

            public void setQueryParameter(@Nullable String queryParameter) {
                this.queryParameter = queryParameter;
            }

            public @Nullable Integer getPathSegment() {
                return this.pathSegment;
            }

            public void setPathSegment(@Nullable Integer pathSegment) {
                this.pathSegment = pathSegment;
            }

            public Map<MediaType, String> getMediaTypeParameter() {
                return this.mediaTypeParameter;
            }

            public void setMediaTypeParameter(Map<MediaType, String> mediaTypeParameter) {
                this.mediaTypeParameter = mediaTypeParameter;
            }
        }
    }

    public static enum MatchingStrategy {
        ANT_PATH_MATCHER,
        PATH_PATTERN_PARSER;

    }
}

