/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.system.JavaVersion;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

@Order(value=-2147483628)
class OnJavaCondition
extends SpringBootCondition {
    private static final JavaVersion JVM_VERSION = JavaVersion.getJavaVersion();

    OnJavaCondition() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnJava.class.getName());
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        ConditionalOnJava.Range range = (ConditionalOnJava.Range)((Object)attributes.get("range"));
        Assert.state((range != null ? 1 : 0) != 0, (String)"'range' must not be null");
        JavaVersion version = (JavaVersion)attributes.get("value");
        Assert.state((version != null ? 1 : 0) != 0, (String)"'version' must not be null");
        return this.getMatchOutcome(range, JVM_VERSION, version);
    }

    protected ConditionOutcome getMatchOutcome(ConditionalOnJava.Range range, JavaVersion runningVersion, JavaVersion version) {
        boolean match = this.isWithin(runningVersion, range, version);
        String expected = String.format(range != ConditionalOnJava.Range.EQUAL_OR_NEWER ? "(older than %s)" : "(%s or newer)", version);
        ConditionMessage message = ConditionMessage.forCondition(ConditionalOnJava.class, expected).foundExactly(runningVersion);
        return new ConditionOutcome(match, message);
    }

    private boolean isWithin(JavaVersion runningVersion, ConditionalOnJava.Range range, JavaVersion version) {
        if (range == ConditionalOnJava.Range.EQUAL_OR_NEWER) {
            return runningVersion.isEqualOrNewerThan(version);
        }
        if (range == ConditionalOnJava.Range.OLDER_THAN) {
            return runningVersion.isOlderThan(version);
        }
        throw new IllegalStateException("Unknown range " + String.valueOf((Object)range));
    }
}

