/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge.dfu;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DFUFile
implements Closeable {
    private static final byte[] DFU_SIGNATURE = "DfuSe".getBytes();
    private final Prefix prefix;
    private final List<DFUImage> images;
    private final Suffix suffix;
    private final boolean valid;
    public static final BinWriter BIN = new BinWriter();

    public DFUFile(InputStream inputStream) throws IOException {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(inputStream));){
            this.prefix = Prefix.read(in);
            if (!Arrays.equals(this.prefix.signature, DFU_SIGNATURE)) {
                throw new IOException("Invalid DFU signature");
            }
            if (this.prefix.targets != 1) {
                throw new IOException("Only single-target DFU files are supported");
            }
            this.images = new ArrayList<DFUImage>(this.prefix.targets);
            for (int i = 0; i < this.prefix.targets; ++i) {
                DFUImage image = DFUImage.read(in);
                if (!image.valid()) {
                    throw new IOException("Invalid DFU image");
                }
                this.images.add(image);
            }
            this.suffix = Suffix.read(in);
            this.valid = true;
        }
    }

    public DFUFile(String filename) throws IOException {
        this(new FileInputStream(filename));
    }

    public boolean isValid() {
        return this.valid;
    }

    public int fileFormatVersion() {
        return this.prefix.version & 0xFF;
    }

    public int vendor() {
        return this.suffix.vendor & 0xFFFF;
    }

    public int product() {
        return this.suffix.product & 0xFFFF;
    }

    public int deviceVersion() {
        return this.suffix.deviceVersion & 0xFFFF;
    }

    public long crc() {
        return (long)this.suffix.crc32 & 0xFFFFFFFFL;
    }

    public List<DFUImage> images() {
        return Collections.unmodifiableList(this.images);
    }

    @Override
    public void close() {
    }

    record Prefix(byte[] signature, byte version, int size, byte targets) {
        static Prefix read(DataInputStream in) throws IOException {
            byte[] sig = in.readNBytes(5);
            byte version = in.readByte();
            int size = Integer.reverseBytes(in.readInt());
            byte targets = in.readByte();
            return new Prefix(sig, version, size, targets);
        }
    }

    public record DFUImage(Prefix prefix, List<DFUElement> elements, boolean valid) {
        private final List<DFUElement> elements;

        public int id() {
            return this.prefix.altSetting & 0xFF;
        }

        public String name() {
            return this.prefix.name.trim();
        }

        public int size() {
            return this.prefix.size;
        }

        public List<DFUElement> elements() {
            return Collections.unmodifiableList(this.elements);
        }

        public long elementsSize(int skip) {
            if (this.elements.isEmpty() || skip >= this.elements.size()) {
                return 0L;
            }
            DFUElement first = this.elements.get(skip);
            DFUElement last = this.elements.getLast();
            return last.address() + (long)last.size() - first.address();
        }

        public void write(String filename, int index, FileWriter writer) throws IOException {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));){
                writer.write(out, this.elements.get(index));
            }
        }

        public void writeAll(String filename, int skip, FileWriter writer) throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
                for (int i = skip; i < this.elements.size(); ++i) {
                    DFUElement e = this.elements.get(i);
                    raf.seek(e.address() - this.elements.get(skip).address());
                    writer.write(raf, e);
                }
            }
        }

        static DFUImage read(DataInputStream in) throws IOException {
            Prefix prefix = Prefix.read(in);
            if (!Arrays.equals(Arrays.copyOf(prefix.signature, 6), "Target".getBytes())) {
                return new DFUImage(prefix, List.of(), false);
            }
            ArrayList<DFUElement> elements = new ArrayList<DFUElement>(prefix.elements);
            for (int i = 0; i < prefix.elements; ++i) {
                elements.add(DFUElement.read(in));
            }
            return new DFUImage(prefix, elements, true);
        }

        record Prefix(byte[] signature, byte altSetting, int isNamed, String name, int size, int elements) {
            static Prefix read(DataInputStream in) throws IOException {
                byte[] sig = in.readNBytes(6);
                byte altSetting = in.readByte();
                int isNamed = Integer.reverseBytes(in.readInt());
                byte[] nameBytes = in.readNBytes(255);
                String name = new String(nameBytes).trim();
                int size = Integer.reverseBytes(in.readInt());
                int elements = Integer.reverseBytes(in.readInt());
                return new Prefix(sig, altSetting, isNamed, name, size, elements);
            }
        }
    }

    record Suffix(short deviceVersion, short product, short vendor, short dfuFormat, byte[] ufd, byte length, int crc32) {
        static Suffix read(DataInputStream in) throws IOException {
            short devVer = Short.reverseBytes(in.readShort());
            short product = Short.reverseBytes(in.readShort());
            short vendor = Short.reverseBytes(in.readShort());
            short dfuFmt = Short.reverseBytes(in.readShort());
            byte[] ufd = in.readNBytes(3);
            byte len = in.readByte();
            int crc = Integer.reverseBytes(in.readInt());
            return new Suffix(devVer, product, vendor, dfuFmt, ufd, len, crc);
        }
    }

    public static final class BinWriter
    implements FileWriter {
        @Override
        public void write(OutputStream out, DFUElement element) throws IOException {
            out.write(element.data());
        }
    }

    public static sealed interface FileWriter
    permits BinWriter {
        public void write(OutputStream var1, DFUElement var2) throws IOException;

        default public void write(RandomAccessFile raf, DFUElement element) throws IOException {
            raf.write(element.data());
        }
    }

    public record DFUElement(long address, int size, byte[] data) {
        static DFUElement read(DataInputStream in) throws IOException {
            long address = Integer.toUnsignedLong(Integer.reverseBytes(in.readInt()));
            int size = Integer.reverseBytes(in.readInt());
            byte[] data = in.readNBytes(size);
            return new DFUElement(address, size, data);
        }
    }
}

