/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.internal.SqlTypedMappingImpl;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;

@Internal
public class UnionSubclassEntityPersister
extends AbstractEntityPersister {
    private final String subquery;
    private final String tableName;
    private final String[] subclassTableNames;
    private final String[] spaces;
    private final String[] subclassSpaces;
    private final String[] subclassTableExpressions;
    private final Object discriminatorValue;
    private final String discriminatorSQLValue;
    private final BasicType<?> discriminatorType;
    private final Map<Object, String> subclassByDiscriminatorValue = new HashMap<Object, String>();
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;

    public UnionSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        this.validateGenerator();
        Dialect dialect = creationContext.getDialect();
        this.tableName = this.determineTableName(persistentClass.getTable());
        this.subclassTableNames = new String[]{this.tableName};
        this.customSQLInsert = new String[]{persistentClass.getCustomSQLInsert()};
        this.insertCallable = new boolean[]{persistentClass.isCustomInsertCallable()};
        this.insertExpectations = new Expectation[]{Expectations.createExpectation(persistentClass.getInsertExpectation(), persistentClass.isCustomInsertCallable())};
        this.customSQLUpdate = new String[]{persistentClass.getCustomSQLUpdate()};
        this.updateCallable = new boolean[]{persistentClass.isCustomUpdateCallable()};
        this.updateExpectations = new Expectation[]{Expectations.createExpectation(persistentClass.getUpdateExpectation(), persistentClass.isCustomUpdateCallable())};
        this.customSQLDelete = new String[]{persistentClass.getCustomSQLDelete()};
        this.deleteCallable = new boolean[]{persistentClass.isCustomDeleteCallable()};
        this.deleteExpectations = new Expectation[]{Expectations.createExpectation(persistentClass.getDeleteExpectation(), persistentClass.isCustomDeleteCallable())};
        this.discriminatorValue = persistentClass.getSubclassId();
        this.discriminatorSQLValue = String.valueOf(persistentClass.getSubclassId());
        this.discriminatorType = creationContext.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        this.subclassByDiscriminatorValue.put(persistentClass.getSubclassId(), persistentClass.getEntityName());
        if (persistentClass.isPolymorphic()) {
            for (Subclass subclass : persistentClass.getSubclasses()) {
                this.subclassByDiscriminatorValue.put(subclass.getSubclassId(), subclass.getEntityName());
            }
        }
        int spacesSize = 1 + persistentClass.getSynchronizedTables().size();
        this.spaces = new String[spacesSize];
        this.spaces[0] = this.tableName;
        Iterator<String> iter = persistentClass.getSynchronizedTables().iterator();
        for (int i = 1; i < spacesSize; ++i) {
            this.spaces[i] = iter.next();
        }
        HashSet<String> subclassTables = new HashSet<String>();
        for (Table table : persistentClass.getSubclassTableClosure()) {
            subclassTables.add(this.determineTableName(table));
        }
        this.subclassSpaces = ArrayHelper.toStringArray(subclassTables);
        this.subquery = this.generateSubquery(persistentClass, creationContext.getMetadata());
        ArrayList<String> tableExpressions = new ArrayList<String>(this.subclassSpaces.length * 2);
        Collections.addAll(tableExpressions, this.subclassSpaces);
        tableExpressions.add(this.subquery);
        for (PersistentClass parentPersistentClass = persistentClass.getSuperclass(); parentPersistentClass != null; parentPersistentClass = parentPersistentClass.getSuperclass()) {
            tableExpressions.add(this.generateSubquery(parentPersistentClass, creationContext.getMetadata()));
        }
        for (PersistentClass subPersistentClass : persistentClass.getSubclassClosure()) {
            if (!subPersistentClass.hasSubclasses()) continue;
            tableExpressions.add(this.generateSubquery(subPersistentClass, creationContext.getMetadata()));
        }
        this.subclassTableExpressions = ArrayHelper.toStringArray(tableExpressions);
        if (this.hasMultipleTables()) {
            int idColumnSpan = this.getIdentifierColumnSpan();
            ArrayList<String> tableNames = new ArrayList<String>();
            ArrayList<String[]> keyColumns = new ArrayList<String[]>();
            for (Table table : persistentClass.getSubclassTableClosure()) {
                if (table.isAbstractUnionTable()) continue;
                tableNames.add(this.determineTableName(table));
                String[] key = new String[idColumnSpan];
                List<Column> columns = table.getPrimaryKey().getColumnsInOriginalOrder();
                for (int k = 0; k < idColumnSpan; ++k) {
                    key[k] = columns.get(k).getQuotedName(dialect);
                }
                keyColumns.add(key);
            }
            this.constraintOrderedTableNames = ArrayHelper.toStringArray(tableNames);
            this.constraintOrderedKeyColumnNames = ArrayHelper.to2DStringArray(keyColumns);
        } else {
            this.constraintOrderedTableNames = new String[]{this.tableName};
            this.constraintOrderedKeyColumnNames = new String[][]{this.getIdentifierColumnNames()};
        }
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    protected void validateGenerator() {
        if (this.getGenerator() instanceof IdentityGenerator) {
            throw new MappingException("Cannot use identity column key generation with <union-subclass> mapping for: " + this.getEntityName());
        }
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        for (String subclassTableExpression : this.subclassTableExpressions) {
            if (!subclassTableExpression.equals(tableExpression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UnionTableReference createPrimaryTableReference(SqlAliasBase sqlAliasBase, SqlAstCreationState creationState) {
        sqlAliasBase = SqlAliasBase.from(sqlAliasBase, null, this, creationState.getSqlAliasBaseGenerator());
        return new UnionTableReference(this.getTableName(), this.subclassTableExpressions, sqlAliasBase.generateNewAlias());
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, SqlAliasBase sqlAliasBase, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState) {
        return new UnionTableGroup(canUseInnerJoins, navigablePath, this.createPrimaryTableReference(sqlAliasBase, creationState), this, explicitSourceAlias);
    }

    @Override
    public boolean needsDiscriminator() {
        return false;
    }

    @Override
    public Serializable[] getQuerySpaces() {
        return this.subclassSpaces;
    }

    @Override
    public String getRootTableName() {
        return this.tableName;
    }

    @Override
    public String getTableName() {
        return this.hasSubclasses() ? this.subquery : this.tableName;
    }

    @Override
    public BasicType<?> getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Map<Object, String> getSubclassByDiscriminatorValue() {
        return this.subclassByDiscriminatorValue;
    }

    @Override
    public TableDetails getMappedTableDetails() {
        return this.getTableMapping(0);
    }

    @Override
    public TableDetails getIdentifierTableDetails() {
        return this.getTableMapping(0);
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    @Override
    public String[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    protected boolean shouldProcessSuperMapping() {
        return false;
    }

    @Override
    public boolean hasDuplicateTables() {
        return false;
    }

    @Override
    public String getTableName(int j) {
        return this.tableName;
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.getIdentifierColumnNames();
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return false;
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return true;
    }

    @Override
    public String getAttributeMutationTableName(int i) {
        return this.getTableName();
    }

    @Override
    public String physicalTableNameForMutation(SelectableMapping selectableMapping) {
        assert (!selectableMapping.isFormula());
        return this.tableName;
    }

    @Override
    protected boolean isIdentifierTable(String tableExpression) {
        return tableExpression.equals(this.getRootTableName());
    }

    @Override
    public boolean hasMultipleTables() {
        return this.isAbstract() || this.hasSubclasses();
    }

    @Override
    public void pruneForSubclasses(TableGroup tableGroup, Map<String, EntityNameUse> entityNameUses) {
        NamedTableReference tableReference = (NamedTableReference)tableGroup.getTableReference(this.getRootTableName());
        if (tableReference == null) {
            throw new UnknownTableReferenceException(this.getRootTableName(), "Couldn't find table reference");
        }
        tableReference.setPrunedTableExpression(this.generateSubquery(entityNameUses));
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition], this.getIdentifierMapping()::getJdbcMapping));
        }
    }

    @Override
    protected void visitMutabilityOrderedTables(AbstractEntityPersister.MutabilityOrderedTableConsumer consumer) {
        consumer.consume(this.tableName, 0, () -> columnConsumer -> columnConsumer.accept(this.getIdentifierMapping(), this.tableName, this.getIdentifierColumnNames()));
    }

    @Override
    protected boolean isPhysicalDiscriminator() {
        return false;
    }

    @Override
    protected EntityDiscriminatorMapping generateDiscriminatorMapping(PersistentClass bootEntityDescriptor) {
        return this.hasSubclasses() ? super.generateDiscriminatorMapping(bootEntityDescriptor) : null;
    }

    @Override
    public int getTableSpan() {
        return 1;
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return new int[this.getPropertySpan()];
    }

    protected String generateSubquery(PersistentClass model, Metadata mapping) {
        Dialect dialect = this.getFactory().getJdbcServices().getDialect();
        if (!model.hasSubclasses()) {
            return model.getTable().getQualifiedName(this.getFactory().getSqlStringGenerationContext());
        }
        LinkedHashSet<Column> columns = new LinkedHashSet<Column>();
        for (Table table : model.getSubclassTableClosure()) {
            if (table.isAbstractUnionTable()) continue;
            columns.addAll(table.getColumns());
        }
        StringBuilder subquery = new StringBuilder().append("(");
        JoinedList classes = new JoinedList(List.of(model), Collections.unmodifiableList(model.getSubclasses()));
        for (PersistentClass clazz : classes) {
            Table table = clazz.getTable();
            if (table.isAbstractUnionTable()) continue;
            if (subquery.length() > 1) {
                subquery.append(" union ");
                if (dialect.supportsUnionAll()) {
                    subquery.append("all ");
                }
            }
            subquery.append("select ");
            for (Column col : columns) {
                if (!table.containsColumn(col)) {
                    subquery.append(this.getSelectClauseNullString(col, dialect)).append(" as ");
                }
                subquery.append(col.getQuotedName(dialect)).append(", ");
            }
            subquery.append(clazz.getSubclassId()).append(" as clazz_ from ").append(table.getQualifiedName(this.getFactory().getSqlStringGenerationContext()));
        }
        return subquery.append(")").toString();
    }

    private String getSelectClauseNullString(Column col, Dialect dialect) {
        return dialect.getSelectClauseNullString(new SqlTypedMappingImpl(col.getTypeName(), col.getLength(), col.getPrecision(), col.getScale(), col.getTemporalPrecision(), col.getType()), this.getFactory().getTypeConfiguration());
    }

    protected String generateSubquery(Map<String, EntityNameUse> entityNameUses) {
        UnionSubclassEntityPersister persister;
        if (!this.hasSubclasses()) {
            return this.getTableName();
        }
        Dialect dialect = this.getFactory().getJdbcServices().getDialect();
        MappingMetamodelImplementor metamodel = this.getFactory().getMappingMetamodel();
        LinkedHashMap<String, Map<String, SelectableMapping>> selectables = new LinkedHashMap<String, Map<String, SelectableMapping>>();
        HashSet<String> tablesToUnion = new HashSet<String>(entityNameUses.size());
        for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
            persister = (UnionSubclassEntityPersister)metamodel.getEntityDescriptor(entry.getKey());
            if (entry.getValue().getKind() == EntityNameUse.UseKind.FILTER && !persister.isAbstract()) {
                tablesToUnion.add(persister.getRootTableName());
            }
            persister.collectSelectableOwners(selectables);
        }
        if (tablesToUnion.isEmpty()) {
            for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
                if (entry.getValue().getKind() != EntityNameUse.UseKind.TREAT) continue;
                persister = (UnionSubclassEntityPersister)metamodel.getEntityDescriptor(entry.getKey());
                tablesToUnion.addAll(Arrays.asList(persister.getConstraintOrderedTableNameClosure()));
            }
            if (tablesToUnion.isEmpty()) {
                return this.getTableName();
            }
        }
        StringBuilder buf = new StringBuilder(this.subquery.length()).append("(");
        Collection<EntityMappingType> subMappingTypes = this.getSubMappingTypes();
        ArrayList<EntityMappingType> subMappingTypesAndThis = new ArrayList<EntityMappingType>(subMappingTypes.size() + 1);
        subMappingTypesAndThis.add(this);
        subMappingTypesAndThis.addAll(subMappingTypes);
        for (EntityMappingType mappingType : subMappingTypesAndThis) {
            EntityPersister persister2 = (EntityPersister)mappingType;
            String subclassTableName = mappingType.hasSubclasses() ? persister2.getRootTableName() : persister2.getTableName();
            if (!tablesToUnion.contains(subclassTableName)) continue;
            if (buf.length() > 1) {
                buf.append(" union ");
                if (dialect.supportsUnionAll()) {
                    buf.append("all ");
                }
            }
            buf.append("select ");
            for (Map<String, SelectableMapping> selectableMappings : selectables.values()) {
                SelectableMapping selectableMapping = selectableMappings.get(subclassTableName);
                if (selectableMapping == null) {
                    selectableMapping = selectableMappings.values().iterator().next();
                    buf.append(dialect.getSelectClauseNullString(selectableMapping, this.getFactory().getTypeConfiguration())).append(" as ");
                }
                if (selectableMapping.isFormula()) {
                    buf.append(selectableMapping.getSelectableName());
                } else {
                    buf.append(selectableMapping.getSelectionExpression());
                }
                buf.append(", ");
            }
            buf.append(persister2.getDiscriminatorSQLValue()).append(" as clazz_ from ").append(subclassTableName);
        }
        return buf.append(")").toString();
    }

    private void collectSelectableOwners(LinkedHashMap<String, Map<String, SelectableMapping>> selectables) {
        if (!this.isAbstract()) {
            SelectableConsumer selectableConsumer = (i, selectable) -> {
                Map selectableMapping = selectables.computeIfAbsent(selectable.getSelectionExpression(), k -> new HashMap());
                String subclassTableName = this.hasSubclasses() ? this.getRootTableName() : this.getTableName();
                selectableMapping.put(subclassTableName, selectable);
            };
            this.getIdentifierMapping().forEachSelectable(selectableConsumer);
            if (this.getVersionMapping() != null) {
                this.getVersionMapping().forEachSelectable(selectableConsumer);
            }
            AttributeMappingsList attributeMappings = this.getAttributeMappings();
            int size = attributeMappings.size();
            for (int i2 = 0; i2 < size; ++i2) {
                attributeMappings.get(i2).forEachSelectable(selectableConsumer);
            }
        }
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.getIdentifierColumnNames();
    }

    @Override
    public String getSubclassTableName(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return this.tableName;
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNames;
    }

    @Override
    public int getSubclassTableSpan() {
        return 1;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        if (j != 0) {
            throw new AssertionFailure("only one table");
        }
        return true;
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getConstraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new StaticFilterAliasGenerator(rootAlias);
    }
}

