/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.security;

import io.github.wimdeblauwe.htmx.spring.boot.security.HxLocationRedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class HxLocationRedirectAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final AuthenticationFailureHandler delegate;

    public HxLocationRedirectAuthenticationFailureHandler(String defaultFailureUrl) {
        this(defaultFailureUrl, new HxLocationRedirectStrategy(HttpStatus.UNAUTHORIZED));
    }

    public HxLocationRedirectAuthenticationFailureHandler(String defaultFailureUrl, RedirectStrategy redirectStrategy) {
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler();
        handler.setDefaultFailureUrl(defaultFailureUrl);
        handler.setRedirectStrategy(redirectStrategy);
        this.delegate = handler;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.delegate.onAuthenticationFailure(request, response, exception);
    }
}

