/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.ChecksForResponse;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.exceptions.ActionFailedException;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.InvalidModeException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import com.revrobotics.revui.app.validation.CanID;
import java.util.List;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/pneumatic_hub/{uuid}"})
public class PneumaticHubController {
    private final DeviceDaemon deviceDaemon;

    PneumaticHubController(DeviceDaemon deviceDaemon) {
        this.deviceDaemon = deviceDaemon;
    }

    @GetMapping(value={"/status0"})
    public PneumaticHub.Status0 getStatus0(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        return hub.getStatus0();
    }

    @GetMapping(value={"/status1"})
    public PneumaticHub.Status1 getStatus1(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        return hub.getStatus1();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channel/{index}"})
    public void writeChannel(@PathVariable String descriptor, @PathVariable UUID uuid, @PathVariable int index, @RequestBody int value) {
        if (value >= 3 || value < 0) {
            throw new InvalidModeException();
        }
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        hub.writeChannel(index, value);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/channels/pulse"})
    public void pulseChannels(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody PulseInput input) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        byte[] channelsArray = new byte[input.channelArray.channels.size()];
        for (int i = 0; i < input.channelArray.channels.size(); ++i) {
            channelsArray[i] = input.channelArray.channels.get(i).byteValue();
        }
        hub.pulseChannels(channelsArray, input.duration);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/id"})
    public UUID setCanId(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody @CanID int canId) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        hub.setCanId(canId);
        return Detector.deviceUUID((int)canId, (DeviceType)DeviceType.PNEUMATICS, (Manufacturer)Manufacturer.REV);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/faults/clear"})
    public void clearFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        hub.clearFaults();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/identify"})
    public void identify(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        hub.identify();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"usb-check"})
    public boolean checkIfUsbBridge(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        return (Boolean)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> PneumaticHub.checkIfUsbBridge((CanBridge)canBridge, (CanBus)bus, (int)device.id()));
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @ChecksForResponse
    @GetMapping(value={"/version"})
    public PneumaticHub.Version getVersion(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        PneumaticHub.Version version = hub.getVersion();
        if (version == null) {
            throw new ActionFailedException();
        }
        return version;
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/dfu/enter"})
    public void enterDfuBootloader(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        PneumaticHub hub = this.getPneumaticHub(uuid, decodedDescriptor);
        hub.enterDfuBootloader();
    }

    private PneumaticHub getPneumaticHub(UUID uuid, String decodedDescriptor) {
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        PneumaticHub hub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getPneumaticHub(device.id());
        if (hub == null) {
            throw new DeviceNotPresentException(uuid);
        }
        return hub;
    }

    private void throwIfNeeded(FRCCanDevice device, UUID uuid) {
        if (device == null) {
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() != RecognizedDevice.PH) {
            throw new WrongDeviceTypeException();
        }
    }

    public record PulseInput(int duration, ChannelArray channelArray) {
    }

    public record ChannelArray(List<Integer> channels) {
    }
}

