/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.devices;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.annotations.ChecksForResponse;
import com.revrobotics.revui.app.annotations.EnforcesDeviceType;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.exceptions.ActionFailedException;
import com.revrobotics.revui.app.exceptions.DeviceNotPresentException;
import com.revrobotics.revui.app.exceptions.WrongDeviceTypeException;
import com.revrobotics.revui.app.validation.CanID;
import java.util.UUID;
import java.util.logging.Logger;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/bus/{descriptor}/power_hub/{uuid}"})
@Validated
public class PowerHubController {
    private static final Logger logger = Logger.getLogger(PowerHubController.class.getName());
    private final DeviceDaemon deviceDaemon;

    PowerHubController(DeviceDaemon deviceDaemon) {
        this.deviceDaemon = deviceDaemon;
    }

    @GetMapping(value={"/status0"})
    public PowerHub.Status0 getStatus0(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        return (PowerHub.Status0)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (bridge, bus) -> hub.getStatus0());
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/identify"})
    public void identify(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        hub.identify();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/switchable_channel"})
    public void switchableChannel(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody boolean on) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        hub.setSwitchableChannel(on);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/id"})
    public UUID setCanId(@PathVariable String descriptor, @PathVariable UUID uuid, @RequestBody @CanID int canId) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        hub.setCanId(canId);
        return Detector.deviceUUID((int)canId, (DeviceType)DeviceType.POWER_DISTRIBUTION, (Manufacturer)Manufacturer.REV);
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/faults/clear"})
    public void clearFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        hub.clearFaults();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"/faults/hardware"})
    public PowerHub.HardwareFaults getHardwareFaults(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        return hub.getHardwareFaults();
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @GetMapping(value={"usb-check"})
    public boolean checkIfUsbBridge(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        return (Boolean)this.deviceDaemon.doWithRawCanBridge(decodedDescriptor, (canBridge, bus) -> PowerHub.checkIfUsbBridge((CanBridge)canBridge, (CanBus)bus, (int)device.id()));
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @ChecksForResponse
    @GetMapping(value={"/version"})
    public PowerHub.Version getVersion(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        PowerHub.Version version = hub.getVersion();
        if (version == null) {
            throw new ActionFailedException();
        }
        return version;
    }

    @Success
    @StandardExceptions
    @EnforcesDeviceType
    @PostMapping(value={"/dfu/enter"})
    public void enterDfuBootloader(@PathVariable String descriptor, @PathVariable UUID uuid) {
        String decodedDescriptor = CanBridgeController.decodeDescriptor(descriptor);
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        PowerHub hub = this.getPowerHub(uuid, decodedDescriptor);
        hub.enterDfuBootloader();
    }

    private PowerHub getPowerHub(UUID uuid, String decodedDescriptor) {
        FRCCanDevice device = this.deviceDaemon.getDeviceManager().getDevice(decodedDescriptor, uuid);
        this.throwIfNeeded(device, uuid);
        PowerHub hub = this.deviceDaemon.getDeviceManager().getRevLibDeviceManager().getPowerHub(device.id());
        if (hub == null) {
            throw new DeviceNotPresentException(uuid);
        }
        return hub;
    }

    private void throwIfNeeded(FRCCanDevice device, UUID uuid) {
        if (device == null) {
            logger.severe("No PDH with uuid " + String.valueOf(uuid) + " found");
            throw new DeviceNotPresentException(uuid);
        }
        if (device.type() != RecognizedDevice.PDH) {
            throw new WrongDeviceTypeException();
        }
    }
}

