/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.ui;

import com.formdev.flatlaf.FlatDarculaLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AppSplashScreen {
    private static JWindow splash;

    private static JPanel createBackground() {
        final ImageIcon backgroundImage = AppSplashScreen.loadSplashImage();
        if (backgroundImage == null) {
            return null;
        }
        JPanel content = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int w = this.getWidth();
                int h = this.getHeight();
                g.drawImage(backgroundImage.getImage(), 0, 0, w, h, null);
            }
        };
        content.setSize(backgroundImage.getIconWidth(), backgroundImage.getIconHeight());
        content.setBackground(new Color(0, 0, 0, 0));
        content.setLayout(new BorderLayout());
        return content;
    }

    private static JPanel createProgressBar() {
        int splashHeight = splash.getHeight();
        JPanel content = new JPanel(new GridBagLayout());
        content.setOpaque(false);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(300, 18));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 15;
        gbc.insets = new Insets(0, 0, splashHeight / 4, 0);
        content.add((Component)progressBar, gbc);
        return content;
    }

    public static void showSplashScreen() {
        AppSplashScreen.enableFlatLookAndFeel();
        splash = new JWindow();
        splash.setBackground(new Color(0, 0, 0, 0));
        JPanel background = AppSplashScreen.createBackground();
        if (background == null) {
            return;
        }
        splash.setContentPane(background);
        splash.setSize(background.getSize());
        splash.setLocationRelativeTo(null);
        splash.setVisible(true);
        EventQueue.invokeLater(() -> splash.toFront());
        Timer timer = new Timer(2000, event -> AppSplashScreen.showLoadingAnimation());
        timer.setRepeats(false);
        timer.start();
    }

    public static void closeSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    private static ImageIcon loadSplashImage() {
        URL imageURL = AppSplashScreen.class.getClassLoader().getResource("Splash_Screen.png");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    private static void showLoadingAnimation() {
        JPanel progress = AppSplashScreen.createProgressBar();
        splash.getContentPane().add((Component)progress, "South");
        splash.validate();
    }

    private static void enableFlatLookAndFeel() {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatDarculaLaf());
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
    }
}

