/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge.slcan;

import com.revrobotics.canbridge.CanMessage;

public class SLCanParser {
    static CanMessage parseSLCanMessageOrNull(String message) {
        if (!message.startsWith("T")) {
            return null;
        }
        try {
            String idString = message.substring(1, 9);
            char lengthChar = message.charAt(9);
            int length = SLCanParser.getLength(lengthChar);
            String dataString = message.substring(10, 10 + 2 * length);
            int id = Integer.parseInt(idString, 16);
            byte[] data = SLCanParser.parseData(dataString);
            return CanMessage.createClassic(id, data);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static int getLength(char lengthChar) {
        return lengthChar - 48;
    }

    private static byte[] parseData(String dataString) {
        byte[] result = new byte[dataString.length() / 2];
        for (int i = 0; i < dataString.length(); i += 2) {
            String byteString = dataString.substring(i, i + 2);
            result[i / 2] = (byte)Integer.parseInt(byteString, 16);
        }
        return result;
    }

    static String encodeCanMessage(CanMessage canMessage) {
        char command = canMessage.isRtr() ? (char)'R' : 'T';
        String idString = String.format("%08x", canMessage.messageId());
        char lengthChar = SLCanParser.lengthCharacter(canMessage.data().length);
        String dataString = SLCanParser.dataString(canMessage.data());
        String delimiter = "\r\n";
        return command + idString + lengthChar + dataString + delimiter;
    }

    private static char lengthCharacter(int length) {
        if (length <= 8) {
            return (char)(length + 48);
        }
        return '\u0000';
    }

    private static String dataString(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte datum : data) {
            String byteText = String.format("%02x", datum);
            result.append(byteText);
        }
        return result.toString();
    }
}

