/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.observation.DefaultMeterObservationHandler;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MeterRegistryCustomizer;
import org.springframework.boot.micrometer.metrics.autoconfigure.MeterRegistryPostProcessor;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.PropertiesMeterFilter;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationHandlerGroup;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.annotation.Order;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={Timed.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public final class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    static MeterRegistryPostProcessor meterRegistryPostProcessor(ApplicationContext applicationContext, ObjectProvider<MetricsProperties> metricsProperties, ObjectProvider<MeterRegistryCustomizer<?>> meterRegistryCustomizers, ObjectProvider<MeterFilter> meterFilters, ObjectProvider<MeterBinder> meterBinders) {
        return new MeterRegistryPostProcessor(applicationContext, metricsProperties, meterRegistryCustomizers, meterFilters, meterBinders);
    }

    @Bean
    @Order(value=0)
    PropertiesMeterFilter propertiesMeterFilter(MetricsProperties properties) {
        return new PropertiesMeterFilter(properties);
    }

    @Bean
    MeterRegistryCloser meterRegistryCloser(ObjectProvider<MeterRegistry> meterRegistries) {
        return new MeterRegistryCloser(meterRegistries.orderedStream().toList());
    }

    @Bean
    ObservationHandlerGroup metricsObservationHandlerGroup() {
        return ObservationHandlerGroup.of(MeterObservationHandler.class);
    }

    @Bean
    DefaultMeterObservationHandler defaultMeterObservationHandler(ObjectProvider<MeterRegistry> meterRegistryProvider, Clock clock, MetricsProperties properties) {
        MeterRegistry meterRegistry = (MeterRegistry)meterRegistryProvider.getIfAvailable(() -> new CompositeMeterRegistry(clock));
        return new DefaultMeterObservationHandler(meterRegistry, (DefaultMeterObservationHandler.IgnoredMeters[])properties.getObservations().getIgnoredMeters().toArray(DefaultMeterObservationHandler.IgnoredMeters[]::new));
    }

    static class MeterRegistryCloser
    implements ApplicationListener<ContextClosedEvent> {
        private final List<MeterRegistry> meterRegistries;

        MeterRegistryCloser(List<MeterRegistry> meterRegistries) {
            this.meterRegistries = meterRegistries;
        }

        public void onApplicationEvent(ContextClosedEvent event) {
            for (MeterRegistry meterRegistry : this.meterRegistries) {
                if (meterRegistry.isClosed()) continue;
                meterRegistry.close();
            }
        }
    }
}

