/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.javapoet;

import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeWriter;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.Util;

public final class TypeVariableName
extends TypeName {
    private final String name;
    private final List<TypeName> bounds;

    private TypeVariableName(String name, List<TypeName> bounds) {
        this(name, bounds, new ArrayList<AnnotationSpec>());
    }

    private TypeVariableName(String name, List<TypeName> bounds, List<AnnotationSpec> annotations) {
        super(annotations);
        this.name = Util.checkNotNull(name, "name == null", new Object[0]);
        this.bounds = Util.immutableList(bounds);
        for (TypeName bound : this.bounds) {
            Util.checkArgument(!bound.isPrimitive() && bound != VOID, "invalid bound: %s", bound);
        }
    }

    public String name() {
        return this.name;
    }

    public List<TypeName> bounds() {
        return this.bounds;
    }

    @Override
    public TypeVariableName annotated(List<AnnotationSpec> annotations) {
        return new TypeVariableName(this.name, this.bounds, annotations);
    }

    @Override
    public TypeName withoutAnnotations() {
        return new TypeVariableName(this.name, this.bounds);
    }

    public TypeVariableName withBounds(Type ... bounds) {
        return this.withBounds(TypeName.list(bounds));
    }

    public TypeVariableName withBounds(TypeName ... bounds) {
        return this.withBounds(Arrays.asList(bounds));
    }

    public TypeVariableName withBounds(List<? extends TypeName> bounds) {
        ArrayList<TypeName> newBounds = new ArrayList<TypeName>();
        newBounds.addAll(this.bounds);
        newBounds.addAll(bounds);
        return new TypeVariableName(this.name, newBounds, this.annotations());
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        this.emitAnnotations(out);
        return out.emitAndIndent(this.name);
    }

    private static TypeVariableName of(String name, List<TypeName> bounds) {
        ArrayList<TypeName> boundsNoObject = new ArrayList<TypeName>(bounds);
        boundsNoObject.remove(ClassName.OBJECT);
        return new TypeVariableName(name, Collections.unmodifiableList(boundsNoObject));
    }

    public static TypeVariableName get(String name) {
        return TypeVariableName.of(name, Collections.emptyList());
    }

    public static TypeVariableName get(String name, TypeName ... bounds) {
        return TypeVariableName.of(name, Arrays.asList(bounds));
    }

    public static TypeVariableName get(String name, Type ... bounds) {
        return TypeVariableName.of(name, TypeName.list(bounds));
    }

    public static TypeVariableName get(javax.lang.model.type.TypeVariable mirror) {
        return TypeVariableName.get((TypeParameterElement)mirror.asElement());
    }

    static TypeVariableName get(javax.lang.model.type.TypeVariable mirror, Map<TypeParameterElement, TypeVariableName> typeVariables) {
        TypeParameterElement element = (TypeParameterElement)mirror.asElement();
        TypeVariableName typeVariableName = typeVariables.get(element);
        if (typeVariableName == null) {
            ArrayList<TypeName> bounds = new ArrayList<TypeName>();
            for (TypeMirror typeMirror : element.getBounds()) {
                typeVariableName = new TypeVariableName(element.getSimpleName().toString(), bounds);
                typeVariables.put(element, typeVariableName);
                bounds.add(TypeName.get(typeMirror, typeVariables));
            }
            bounds.remove(ClassName.OBJECT);
            typeVariableName = new TypeVariableName(element.getSimpleName().toString(), bounds);
            typeVariables.put(element, typeVariableName);
        }
        return typeVariableName;
    }

    public static TypeVariableName get(TypeParameterElement element) {
        String name = element.getSimpleName().toString();
        List<? extends TypeMirror> boundsMirrors = element.getBounds();
        ArrayList<TypeName> boundsTypeNames = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : boundsMirrors) {
            boundsTypeNames.add(TypeName.get(typeMirror));
        }
        return TypeVariableName.of(name, boundsTypeNames);
    }

    public static TypeVariableName get(TypeVariable<?> type) {
        return TypeVariableName.get(type, new LinkedHashMap<Type, TypeVariableName>());
    }

    static TypeVariableName get(TypeVariable<?> type, Map<Type, TypeVariableName> map) {
        TypeVariableName result = map.get(type);
        if (result == null) {
            ArrayList<TypeName> bounds = new ArrayList<TypeName>();
            List<TypeName> visibleBounds = Collections.unmodifiableList(bounds);
            result = new TypeVariableName(type.getName(), visibleBounds);
            map.put(type, result);
            for (Type bound : type.getBounds()) {
                bounds.add(TypeName.get(bound, map));
            }
            bounds.remove(ClassName.OBJECT);
        }
        return result;
    }
}

