/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.mail;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.jakarta9.instrument.mail.MailObservationDocumentation;
import io.micrometer.jakarta9.instrument.mail.MailSendObservationContext;
import io.micrometer.jakarta9.instrument.mail.MailSendObservationConvention;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class DefaultMailSendObservationConvention
implements MailSendObservationConvention {
    private static final String UNKNOWN = "unknown";
    private static final KeyValue NETWORK_PROTOCOL_NAME_UNKNOWN = MailObservationDocumentation.LowCardinalityKeyNames.NETWORK_PROTOCOL_NAME.withValue("unknown");
    private static final KeyValue SERVER_PORT_UNKNOWN = MailObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue("unknown");
    private static final KeyValue SERVER_ADDRESS_UNKNOWN = MailObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue("unknown");
    private static final KeyValue SMTP_MESSAGE_SUBJECT_UNKNOWN = MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_SUBJECT.withValue("unknown");
    private static final KeyValue SMTP_MESSAGE_FROM_UNKNOWN = MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_FROM.withValue("unknown");
    private static final KeyValue SMTP_MESSAGE_ID_UNKNOWN = MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_ID.withValue("unknown");
    private static final Map<Message.RecipientType, KeyName> RECIPIENT_TYPE_KEY_NAME_MAP;
    static final Set<Message.RecipientType> RECIPIENT_TYPES;
    private static final Map<Message.RecipientType, KeyValue> RECIPIENT_TYPE_UNKNOWN_MAP;

    public String getName() {
        return "mail.send";
    }

    public String getContextualName(MailSendObservationContext context) {
        return "mail send";
    }

    public KeyValues getLowCardinalityKeyValues(MailSendObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.serverAddress(context), this.serverPort(context), this.networkProtocolName(context)});
    }

    public KeyValues getHighCardinalityKeyValues(MailSendObservationContext context) {
        Message message = (Message)context.getCarrier();
        if (message == null) {
            return KeyValues.empty();
        }
        ArrayList values = new ArrayList();
        this.smtpMessageSubject(message).ifPresent(values::add);
        this.smtpMessageFrom(message).ifPresent(values::add);
        for (Message.RecipientType recipientType : RECIPIENT_TYPES) {
            this.smtpMessageRecipients(message, recipientType).ifPresent(values::add);
        }
        return KeyValues.of(values);
    }

    private KeyValue serverAddress(MailSendObservationContext context) {
        String host = context.getHost();
        if (host == null || host.isEmpty()) {
            return SERVER_ADDRESS_UNKNOWN;
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(host);
    }

    private KeyValue serverPort(MailSendObservationContext context) {
        int port = context.getPort();
        if (port <= 0) {
            return SERVER_PORT_UNKNOWN;
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue(String.valueOf(port));
    }

    private KeyValue networkProtocolName(MailSendObservationContext context) {
        String protocol = context.getProtocol();
        if (protocol == null || protocol.isEmpty()) {
            return NETWORK_PROTOCOL_NAME_UNKNOWN;
        }
        return MailObservationDocumentation.LowCardinalityKeyNames.NETWORK_PROTOCOL_NAME.withValue(protocol);
    }

    private Optional<KeyValue> smtpMessageSubject(Message message) {
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_SUBJECT, () -> Optional.ofNullable(message.getSubject()), SMTP_MESSAGE_SUBJECT_UNKNOWN);
    }

    private Optional<KeyValue> smtpMessageFrom(Message message) {
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_FROM, () -> this.addressesToValue(message.getFrom()), SMTP_MESSAGE_FROM_UNKNOWN);
    }

    private Optional<KeyValue> smtpMessageRecipients(Message message, Message.RecipientType recipientType) {
        KeyName keyName = Objects.requireNonNull(RECIPIENT_TYPE_KEY_NAME_MAP.get(recipientType));
        KeyValue unknownValue = Objects.requireNonNull(RECIPIENT_TYPE_UNKNOWN_MAP.get(recipientType));
        return this.safeExtractValue(keyName, () -> this.addressesToValue(message.getRecipients(recipientType)), unknownValue);
    }

    Optional<KeyValue> smtpMessageId(Message message) {
        return this.safeExtractValue(MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_ID, () -> this.extractHeaderValue(message, "Message-ID"), SMTP_MESSAGE_ID_UNKNOWN);
    }

    private Optional<String> extractHeaderValue(Message message, String headerName) throws MessagingException {
        CharSequence[] header = message.getHeader(headerName);
        if (header == null || header.length == 0) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)", ", header));
    }

    private Optional<KeyValue> safeExtractValue(KeyName key, ValueExtractor extractor, KeyValue unknownValue) {
        try {
            return extractor.extract().map(arg_0 -> ((KeyName)key).withValue(arg_0));
        }
        catch (MessagingException ex) {
            return Optional.of(unknownValue);
        }
    }

    private Optional<String> addressesToValue(Address @Nullable [] addresses) {
        if (addresses == null || addresses.length == 0) {
            return Optional.empty();
        }
        String value = Arrays.stream(addresses).map(Address::toString).collect(Collectors.joining(", "));
        return Optional.of(value);
    }

    static {
        IdentityHashMap<Object, Object> map = new IdentityHashMap<Message.RecipientType, KeyName>();
        map.put(Message.RecipientType.TO, (Object)MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_TO);
        map.put(Message.RecipientType.CC, (Object)MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_CC);
        map.put(Message.RecipientType.BCC, (Object)MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_BCC);
        map.put(MimeMessage.RecipientType.NEWSGROUPS, (Object)MailObservationDocumentation.HighCardinalityKeyNames.SMTP_MESSAGE_NEWSGROUPS);
        RECIPIENT_TYPE_KEY_NAME_MAP = map;
        RECIPIENT_TYPES = RECIPIENT_TYPE_KEY_NAME_MAP.keySet();
        map = new IdentityHashMap();
        for (Map.Entry<Message.RecipientType, KeyName> entry : RECIPIENT_TYPE_KEY_NAME_MAP.entrySet()) {
            map.put(entry.getKey(), (KeyName)entry.getValue().withValue(UNKNOWN));
        }
        RECIPIENT_TYPE_UNKNOWN_MAP = map;
    }

    private static interface ValueExtractor {
        public Optional<String> extract() throws MessagingException;
    }
}

