/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.support.FilePatternResourceHintsRegistrar;
import org.springframework.boot.context.config.ConfigDataEnvironment;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.StandardConfigDataLocationResolver;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;

class ConfigDataLocationRuntimeHints
implements RuntimeHintsRegistrar {
    private static final Log logger = LogFactory.getLog(ConfigDataLocationRuntimeHints.class);

    ConfigDataLocationRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        List<String> fileNames = this.getFileNames(classLoader);
        List<String> locations = this.getLocations(classLoader);
        List<String> extensions = this.getExtensions(classLoader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering application configuration hints for " + String.valueOf(fileNames) + "(" + String.valueOf(extensions) + ") at " + String.valueOf(locations)));
        }
        FilePatternResourceHintsRegistrar.forClassPathLocations(locations).withFilePrefixes(fileNames).withFileExtensions(extensions).registerHints(hints.resources(), classLoader);
    }

    protected List<String> getFileNames(@Nullable ClassLoader classLoader) {
        return Arrays.asList(StandardConfigDataLocationResolver.DEFAULT_CONFIG_NAMES);
    }

    protected List<String> getLocations(@Nullable ClassLoader classLoader) {
        ArrayList<String> classpathLocations = new ArrayList<String>();
        for (ConfigDataLocation candidate : ConfigDataEnvironment.DEFAULT_SEARCH_LOCATIONS) {
            for (ConfigDataLocation configDataLocation : candidate.split()) {
                String location = configDataLocation.getValue();
                if (!location.startsWith("classpath:")) continue;
                classpathLocations.add(location);
            }
        }
        return classpathLocations;
    }

    protected List<String> getExtensions(@Nullable ClassLoader classLoader) {
        ArrayList<String> extensions = new ArrayList<String>();
        List propertySourceLoaders = this.getSpringFactoriesLoader(classLoader).load(PropertySourceLoader.class);
        for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
            for (String fileExtension : propertySourceLoader.getFileExtensions()) {
                String candidate = "." + fileExtension;
                if (extensions.contains(candidate)) continue;
                extensions.add(candidate);
            }
        }
        return extensions;
    }

    protected SpringFactoriesLoader getSpringFactoriesLoader(@Nullable ClassLoader classLoader) {
        return SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader);
    }
}

