/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.context.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextScope;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebApplicationContextInitializer {
    private static final Log logger = LogFactory.getLog(WebApplicationContextInitializer.class);
    private final ConfigurableWebApplicationContext context;

    public WebApplicationContextInitializer(ConfigurableWebApplicationContext context) {
        this.context = context;
    }

    public void initialize(ServletContext servletContext) throws ServletException {
        this.prepareWebApplicationContext(servletContext);
        this.registerApplicationScope(servletContext, this.context.getBeanFactory());
        WebApplicationContextUtils.registerEnvironmentBeans((ConfigurableListableBeanFactory)this.context.getBeanFactory(), (ServletContext)servletContext);
        for (ServletContextInitializer initializerBean : new ServletContextInitializerBeans((ListableBeanFactory)this.context.getBeanFactory(), new Class[0])) {
            initializerBean.onStartup(servletContext);
        }
    }

    private void prepareWebApplicationContext(ServletContext servletContext) {
        Object rootContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootContext != null) {
            if (rootContext == this) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ServletContextInitializers!");
            }
            return;
        }
        try {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            this.context.setServletContext(servletContext);
            if (logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - this.context.getStartupDate();
                logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
        }
        catch (Error | RuntimeException ex) {
            logger.error((Object)"Context initialization failed", ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
    }

    private void registerApplicationScope(ServletContext servletContext, ConfigurableListableBeanFactory beanFactory) {
        ServletContextScope appScope = new ServletContextScope(servletContext);
        beanFactory.registerScope("application", (Scope)appScope);
        servletContext.setAttribute(ServletContextScope.class.getName(), (Object)appScope);
    }
}

