/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

public class PowerHubCanSpec {
    public static final int STATUS_0_FRAME_ID = 134551552;
    public static final int STATUS_1_FRAME_ID = 134551616;
    public static final int STATUS_2_FRAME_ID = 134551680;
    public static final int STATUS_3_FRAME_ID = 134551744;
    public static final int STATUS_4_FRAME_ID = 134551808;
    public static final int BOOTLOADER_0_FRAME_ID = 134590464;
    public static final int SET_SWITCHABLE_CHANNEL_FRAME_ID = 134547520;
    public static final int GET_STICKY_HARDWARE_FAULTS_FRAME_ID = 134552320;
    public static final int GET_HARDWARE_FAULTS_FRAME_ID = 134552384;
    public static final int CLEAR_FAULTS_FRAME_ID = 134552448;
    public static final int IDENTIFY_FRAME_ID = 134552960;
    public static final int GET_VERSION_FRAME_ID = 134555136;
    public static final int USB_CHECK_FRAME_ID = 134556864;
    public static final int SET_CAN_ID_FRAME_ID = 134578048;
    public static final int STATUS_0_LENGTH = 8;
    public static final int STATUS_1_LENGTH = 8;
    public static final int STATUS_2_LENGTH = 8;
    public static final int STATUS_3_LENGTH = 8;
    public static final int STATUS_4_LENGTH = 8;
    public static final int BOOTLOADER_0_LENGTH = 8;
    public static final int SET_SWITCHABLE_CHANNEL_LENGTH = 1;
    public static final int GET_STICKY_HARDWARE_FAULTS_LENGTH = 8;
    public static final int GET_HARDWARE_FAULTS_LENGTH = 8;
    public static final int CLEAR_FAULTS_LENGTH = 0;
    public static final int IDENTIFY_LENGTH = 0;
    public static final int GET_VERSION_LENGTH = 8;
    public static final int USB_CHECK_LENGTH = 0;
    public static final int SET_CAN_ID_LENGTH = 1;

    private static int packLeftShift(int value, int shift, int mask) {
        return value << shift & mask & 0xFF;
    }

    private static int packRightShift(int value, int shift, int mask) {
        return value >> shift & mask & 0xFF;
    }

    private static int unpackLeftShift8(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFF;
    }

    private static int unpackLeftShift16(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFF;
    }

    private static int unpackLeftShift32(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFFFFFF;
    }

    private static int unpackRightShift8(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFF;
    }

    private static int unpackRightShift16(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFF;
    }

    private static int unpackRightShift32(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFFFFFF;
    }

    public static Status0 status0Unpack(byte[] data) {
        int channel0Current = PowerHubCanSpec.unpackIntBits(data, 0, 10);
        int channel1Current = PowerHubCanSpec.unpackIntBits(data, 10, 10);
        int channel2Current = PowerHubCanSpec.unpackIntBits(data, 20, 10);
        boolean channel0BreakerFault = (data[3] & 0x40) != 0;
        boolean channel1BreakerFault = (data[3] & 0x80) != 0;
        int channel3Current = PowerHubCanSpec.unpackIntBits(data, 32, 10);
        int channel4Current = PowerHubCanSpec.unpackIntBits(data, 42, 10);
        int channel5Current = PowerHubCanSpec.unpackIntBits(data, 52, 10);
        boolean channel2BreakerFault = (data[7] & 0x40) != 0;
        boolean channel3BreakerFault = (data[7] & 0x80) != 0;
        return new Status0(channel0Current, channel1Current, channel2Current, channel0BreakerFault, channel1BreakerFault, channel3Current, channel4Current, channel5Current, channel2BreakerFault, channel3BreakerFault);
    }

    public static Status1 status1Unpack(byte[] data) {
        int channel6Current = PowerHubCanSpec.unpackIntBits(data, 0, 10);
        int channel7Current = PowerHubCanSpec.unpackIntBits(data, 10, 10);
        int channel8Current = PowerHubCanSpec.unpackIntBits(data, 20, 10);
        boolean channel4BreakerFault = (data[3] & 0x40) != 0;
        boolean channel5BreakerFault = (data[3] & 0x80) != 0;
        int channel9Current = PowerHubCanSpec.unpackIntBits(data, 32, 10);
        int channel10Current = PowerHubCanSpec.unpackIntBits(data, 42, 10);
        int channel11Current = PowerHubCanSpec.unpackIntBits(data, 52, 10);
        boolean channel6BreakerFault = (data[7] & 0x40) != 0;
        boolean channel7BreakerFault = (data[7] & 0x80) != 0;
        return new Status1(channel6Current, channel7Current, channel8Current, channel4BreakerFault, channel5BreakerFault, channel9Current, channel10Current, channel11Current, channel6BreakerFault, channel7BreakerFault);
    }

    public static Status2 status2Unpack(byte[] data) {
        int channel12Current = PowerHubCanSpec.unpackIntBits(data, 0, 10);
        int channel13Current = PowerHubCanSpec.unpackIntBits(data, 10, 10);
        int channel14Current = PowerHubCanSpec.unpackIntBits(data, 20, 10);
        boolean channel8BreakerFault = (data[3] & 0x40) != 0;
        boolean channel9BreakerFault = (data[3] & 0x80) != 0;
        int channel15Current = PowerHubCanSpec.unpackIntBits(data, 32, 10);
        int channel16Current = PowerHubCanSpec.unpackIntBits(data, 42, 10);
        int channel17Current = PowerHubCanSpec.unpackIntBits(data, 52, 10);
        boolean channel10BreakerFault = (data[7] & 0x40) != 0;
        boolean channel11BreakerFault = (data[7] & 0x80) != 0;
        return new Status2(channel12Current, channel13Current, channel14Current, channel8BreakerFault, channel9BreakerFault, channel15Current, channel16Current, channel17Current, channel10BreakerFault, channel11BreakerFault);
    }

    public static Status3 status3Unpack(byte[] data) {
        int channel18Current = PowerHubCanSpec.unpackIntBits(data, 0, 10);
        int channel19Current = PowerHubCanSpec.unpackIntBits(data, 10, 10);
        boolean channel12BreakerFault = (data[2] & 0x10) != 0;
        boolean channel13BreakerFault = (data[2] & 0x20) != 0;
        boolean channel14BreakerFault = (data[2] & 0x40) != 0;
        boolean channel15BreakerFault = (data[2] & 0x80) != 0;
        int channel20Current = PowerHubCanSpec.unpackIntBits(data, 24, 8);
        int channel21Current = PowerHubCanSpec.unpackIntBits(data, 32, 8);
        int channel22Current = PowerHubCanSpec.unpackIntBits(data, 40, 8);
        int channel23Current = PowerHubCanSpec.unpackIntBits(data, 48, 8);
        boolean channel16BreakerFault = (data[7] & 1) != 0;
        boolean channel17BreakerFault = (data[7] & 2) != 0;
        boolean channel18BreakerFault = (data[7] & 4) != 0;
        boolean channel19BreakerFault = (data[7] & 8) != 0;
        boolean channel20BreakerFault = (data[7] & 0x10) != 0;
        boolean channel21BreakerFault = (data[7] & 0x20) != 0;
        boolean channel22BreakerFault = (data[7] & 0x40) != 0;
        boolean channel23BreakerFault = (data[7] & 0x80) != 0;
        return new Status3(channel18Current, channel19Current, channel12BreakerFault, channel13BreakerFault, channel14BreakerFault, channel15BreakerFault, channel20Current, channel21Current, channel22Current, channel23Current, channel16BreakerFault, channel17BreakerFault, channel18BreakerFault, channel19BreakerFault, channel20BreakerFault, channel21BreakerFault, channel22BreakerFault, channel23BreakerFault);
    }

    public static Status4 status4Unpack(byte[] data) {
        int vbus = PowerHubCanSpec.unpackIntBits(data, 0, 12);
        boolean enabled = (data[1] & 0x10) != 0;
        boolean roboRioPresent = (data[1] & 0x20) != 0;
        int reserved0 = PowerHubCanSpec.unpackIntBits(data, 14, 2);
        boolean brownoutFault = (data[2] & 1) != 0;
        boolean reserved1 = (data[2] & 2) != 0;
        boolean cANWarning = (data[2] & 4) != 0;
        boolean hardwareFault = (data[2] & 8) != 0;
        boolean switchableChannelState = (data[2] & 0x10) != 0;
        boolean stickyBrownoutFault = (data[2] & 0x20) != 0;
        boolean reserved2 = (data[2] & 0x40) != 0;
        boolean stickyCANWarning = (data[2] & 0x80) != 0;
        boolean stickyBusOffFault = (data[3] & 1) != 0;
        boolean stickyHardwareFault = (data[3] & 2) != 0;
        boolean stickyFirmwareFault = (data[3] & 4) != 0;
        boolean stickyChannel20BreakerFault = (data[3] & 8) != 0;
        boolean stickyChannel21BreakerFault = (data[3] & 0x10) != 0;
        boolean stickyChannel22BreakerFault = (data[3] & 0x20) != 0;
        boolean stickyChannel23BreakerFault = (data[3] & 0x40) != 0;
        boolean stickyResetFault = (data[3] & 0x80) != 0;
        int totalCurrent = PowerHubCanSpec.unpackIntBits(data, 32, 8);
        boolean stickyChannel0BreakerFault = (data[5] & 1) != 0;
        boolean stickyChannel1BreakerFault = (data[5] & 2) != 0;
        boolean stickyChannel2BreakerFault = (data[5] & 4) != 0;
        boolean stickyChannel3BreakerFault = (data[5] & 8) != 0;
        boolean stickyChannel4BreakerFault = (data[5] & 0x10) != 0;
        boolean stickyChannel5BreakerFault = (data[5] & 0x20) != 0;
        boolean stickyChannel6BreakerFault = (data[5] & 0x40) != 0;
        boolean stickyChannel7BreakerFault = (data[5] & 0x80) != 0;
        boolean stickyChannel8BreakerFault = (data[6] & 1) != 0;
        boolean stickyChannel9BreakerFault = (data[6] & 2) != 0;
        boolean stickyChannel10BreakerFault = (data[6] & 4) != 0;
        boolean stickyChannel11BreakerFault = (data[6] & 8) != 0;
        boolean stickyChannel12BreakerFault = (data[6] & 0x10) != 0;
        boolean stickyChannel13BreakerFault = (data[6] & 0x20) != 0;
        boolean stickyChannel14BreakerFault = (data[6] & 0x40) != 0;
        boolean stickyChannel15BreakerFault = (data[6] & 0x80) != 0;
        boolean stickyChannel16BreakerFault = (data[7] & 1) != 0;
        boolean stickyChannel17BreakerFault = (data[7] & 2) != 0;
        boolean stickyChannel18BreakerFault = (data[7] & 4) != 0;
        boolean stickyChannel19BreakerFault = (data[7] & 8) != 0;
        int reserved3 = PowerHubCanSpec.unpackIntBits(data, 60, 4);
        return new Status4(vbus, enabled, roboRioPresent, reserved0, brownoutFault, reserved1, cANWarning, hardwareFault, switchableChannelState, stickyBrownoutFault, reserved2, stickyCANWarning, stickyBusOffFault, stickyHardwareFault, stickyFirmwareFault, stickyChannel20BreakerFault, stickyChannel21BreakerFault, stickyChannel22BreakerFault, stickyChannel23BreakerFault, stickyResetFault, totalCurrent, stickyChannel0BreakerFault, stickyChannel1BreakerFault, stickyChannel2BreakerFault, stickyChannel3BreakerFault, stickyChannel4BreakerFault, stickyChannel5BreakerFault, stickyChannel6BreakerFault, stickyChannel7BreakerFault, stickyChannel8BreakerFault, stickyChannel9BreakerFault, stickyChannel10BreakerFault, stickyChannel11BreakerFault, stickyChannel12BreakerFault, stickyChannel13BreakerFault, stickyChannel14BreakerFault, stickyChannel15BreakerFault, stickyChannel16BreakerFault, stickyChannel17BreakerFault, stickyChannel18BreakerFault, stickyChannel19BreakerFault, reserved3);
    }

    public static Bootloader0 bootloader0Unpack(byte[] data) {
        int bLMajor = PowerHubCanSpec.unpackIntBits(data, 0, 8);
        int bLMinor = PowerHubCanSpec.unpackIntBits(data, 8, 8);
        int productID = PowerHubCanSpec.unpackIntBits(data, 16, 16);
        int rsvd = PowerHubCanSpec.unpackIntBits(data, 32, 32);
        return new Bootloader0(bLMajor, bLMinor, productID, rsvd);
    }

    public static SetSwitchableChannel setSwitchableChannelUnpack(byte[] data) {
        boolean value = (data[0] & 1) != 0;
        int reserved = PowerHubCanSpec.unpackIntBits(data, 1, 7);
        return new SetSwitchableChannel(value, reserved);
    }

    public static GetStickyHardwareFaults getStickyHardwareFaultsUnpack(byte[] data) {
        boolean cANInit = (data[0] & 1) != 0;
        boolean cANSend = (data[0] & 2) != 0;
        boolean cANRx = (data[0] & 4) != 0;
        boolean cANSetId = (data[0] & 8) != 0;
        boolean eEPROMRead = (data[0] & 0x10) != 0;
        boolean eEPROMWrite = (data[0] & 0x20) != 0;
        boolean aDCInit = (data[0] & 0x40) != 0;
        boolean cRCInit = (data[0] & 0x80) != 0;
        boolean dACInit = (data[1] & 1) != 0;
        boolean fDCANInit = (data[1] & 2) != 0;
        boolean i2CInit = (data[1] & 4) != 0;
        boolean sYSClockInit = (data[1] & 8) != 0;
        boolean sPIInit = (data[1] & 0x10) != 0;
        boolean timerInit = (data[1] & 0x20) != 0;
        boolean uSARTInit = (data[1] & 0x40) != 0;
        boolean cSAChannelInit = (data[1] & 0x80) != 0;
        boolean cSAChannelRead = (data[2] & 1) != 0;
        boolean cSAChannelInvalid = (data[2] & 2) != 0;
        long reserved = PowerHubCanSpec.unpackLongBits(data, 18, 46);
        return new GetStickyHardwareFaults(cANInit, cANSend, cANRx, cANSetId, eEPROMRead, eEPROMWrite, aDCInit, cRCInit, dACInit, fDCANInit, i2CInit, sYSClockInit, sPIInit, timerInit, uSARTInit, cSAChannelInit, cSAChannelRead, cSAChannelInvalid, reserved);
    }

    public static GetHardwareFaults getHardwareFaultsUnpack(byte[] data) {
        boolean cANInit = (data[0] & 1) != 0;
        boolean cANSend = (data[0] & 2) != 0;
        boolean cANRx = (data[0] & 4) != 0;
        boolean cANSetId = (data[0] & 8) != 0;
        boolean eEPROMRead = (data[0] & 0x10) != 0;
        boolean eEPROMWrite = (data[0] & 0x20) != 0;
        boolean aDCInit = (data[0] & 0x40) != 0;
        boolean cRCInit = (data[0] & 0x80) != 0;
        boolean dACInit = (data[1] & 1) != 0;
        boolean fDCANInit = (data[1] & 2) != 0;
        boolean i2CInit = (data[1] & 4) != 0;
        boolean sYSClockInit = (data[1] & 8) != 0;
        boolean sPIInit = (data[1] & 0x10) != 0;
        boolean timerInit = (data[1] & 0x20) != 0;
        boolean uSARTInit = (data[1] & 0x40) != 0;
        boolean cSAChannelInit = (data[1] & 0x80) != 0;
        boolean cSAChannelRead = (data[2] & 1) != 0;
        boolean cSAChannelInvalid = (data[2] & 2) != 0;
        long reserved = PowerHubCanSpec.unpackLongBits(data, 18, 46);
        return new GetHardwareFaults(cANInit, cANSend, cANRx, cANSetId, eEPROMRead, eEPROMWrite, aDCInit, cRCInit, dACInit, fDCANInit, i2CInit, sYSClockInit, sPIInit, timerInit, uSARTInit, cSAChannelInit, cSAChannelRead, cSAChannelInvalid, reserved);
    }

    public static ClearFaults clearFaultsUnpack(byte[] data) {
        return new ClearFaults();
    }

    public static Identify identifyUnpack(byte[] data) {
        return new Identify();
    }

    public static GetVersion getVersionUnpack(byte[] data) {
        int firmwareFix = PowerHubCanSpec.unpackIntBits(data, 0, 8);
        int firmwareMinor = PowerHubCanSpec.unpackIntBits(data, 8, 8);
        int firmwareYear = PowerHubCanSpec.unpackIntBits(data, 16, 8);
        int hardwareMinor = PowerHubCanSpec.unpackIntBits(data, 24, 8);
        int hardwareMajor = PowerHubCanSpec.unpackIntBits(data, 32, 8);
        int reserved = PowerHubCanSpec.unpackIntBits(data, 40, 24);
        return new GetVersion(firmwareFix, firmwareMinor, firmwareYear, hardwareMinor, hardwareMajor, reserved);
    }

    public static USBCheck uSBCheckUnpack(byte[] data) {
        return new USBCheck();
    }

    public static SetCANID setCANIDUnpack(byte[] data) {
        int id = PowerHubCanSpec.unpackIntBits(data, 0, 8);
        return new SetCANID(id);
    }

    private static int unpackIntBits(byte[] data, int startBit, int length) {
        int result = 0;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            int thisBit = (b & 1 << bitWithinByte) != 0 ? 1 : 0;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    private static long unpackLongBits(byte[] data, int startBit, int length) {
        long result = 0L;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            long thisBit = (b & 1 << bitWithinByte) != 0 ? 1L : 0L;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    public static double status0Channel0CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status0Channel1CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status0Channel2CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status0Channel3CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status0Channel4CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status0Channel5CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel6CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel7CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel8CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel9CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel10CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status1Channel11CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel12CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel13CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel14CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel15CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel16CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status2Channel17CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status3Channel18CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status3Channel19CurrentDecode(int value) {
        return (double)value * 0.125;
    }

    public static double status3Channel20CurrentDecode(int value) {
        return (double)value * 0.0625;
    }

    public static double status3Channel21CurrentDecode(int value) {
        return (double)value * 0.0625;
    }

    public static double status3Channel22CurrentDecode(int value) {
        return (double)value * 0.0625;
    }

    public static double status3Channel23CurrentDecode(int value) {
        return (double)value * 0.0625;
    }

    public static double status4VbusDecode(int value) {
        return (double)value * 0.0078125;
    }

    public static double status4Reserved0Decode(int value) {
        return value * 1;
    }

    public static double status4TotalCurrentDecode(int value) {
        return value * 2;
    }

    public static double status4Reserved3Decode(int value) {
        return value * 1;
    }

    public static double bootloader0BLMajorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0BLMinorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0ProductIDDecode(int value) {
        return value * 1;
    }

    public static double bootloader0RsvdDecode(int value) {
        return value * 1;
    }

    public static double setSwitchableChannelReservedDecode(int value) {
        return value * 1;
    }

    public static double getStickyHardwareFaultsReservedDecode(int value) {
        return value * 1;
    }

    public static double getHardwareFaultsReservedDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareFixDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionFirmwareYearDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersionHardwareMajorDecode(int value) {
        return value * 1;
    }

    public static double getVersionReservedDecode(int value) {
        return value * 1;
    }

    public static double setCANIDIdDecode(int value) {
        return value * 1;
    }

    public record Status0(int channel0Current, int channel1Current, int channel2Current, boolean channel0BreakerFault, boolean channel1BreakerFault, int channel3Current, int channel4Current, int channel5Current, boolean channel2BreakerFault, boolean channel3BreakerFault) {
    }

    public record Status1(int channel6Current, int channel7Current, int channel8Current, boolean channel4BreakerFault, boolean channel5BreakerFault, int channel9Current, int channel10Current, int channel11Current, boolean channel6BreakerFault, boolean channel7BreakerFault) {
    }

    public record Status2(int channel12Current, int channel13Current, int channel14Current, boolean channel8BreakerFault, boolean channel9BreakerFault, int channel15Current, int channel16Current, int channel17Current, boolean channel10BreakerFault, boolean channel11BreakerFault) {
    }

    public record Status3(int channel18Current, int channel19Current, boolean channel12BreakerFault, boolean channel13BreakerFault, boolean channel14BreakerFault, boolean channel15BreakerFault, int channel20Current, int channel21Current, int channel22Current, int channel23Current, boolean channel16BreakerFault, boolean channel17BreakerFault, boolean channel18BreakerFault, boolean channel19BreakerFault, boolean channel20BreakerFault, boolean channel21BreakerFault, boolean channel22BreakerFault, boolean channel23BreakerFault) {
    }

    public record Status4(int vbus, boolean enabled, boolean roboRioPresent, int reserved0, boolean brownoutFault, boolean reserved1, boolean cANWarning, boolean hardwareFault, boolean switchableChannelState, boolean stickyBrownoutFault, boolean reserved2, boolean stickyCANWarning, boolean stickyBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyChannel20BreakerFault, boolean stickyChannel21BreakerFault, boolean stickyChannel22BreakerFault, boolean stickyChannel23BreakerFault, boolean stickyResetFault, int totalCurrent, boolean stickyChannel0BreakerFault, boolean stickyChannel1BreakerFault, boolean stickyChannel2BreakerFault, boolean stickyChannel3BreakerFault, boolean stickyChannel4BreakerFault, boolean stickyChannel5BreakerFault, boolean stickyChannel6BreakerFault, boolean stickyChannel7BreakerFault, boolean stickyChannel8BreakerFault, boolean stickyChannel9BreakerFault, boolean stickyChannel10BreakerFault, boolean stickyChannel11BreakerFault, boolean stickyChannel12BreakerFault, boolean stickyChannel13BreakerFault, boolean stickyChannel14BreakerFault, boolean stickyChannel15BreakerFault, boolean stickyChannel16BreakerFault, boolean stickyChannel17BreakerFault, boolean stickyChannel18BreakerFault, boolean stickyChannel19BreakerFault, int reserved3) {
    }

    public record Bootloader0(int bLMajor, int bLMinor, int productID, int rsvd) {
    }

    public record SetSwitchableChannel(boolean value, int reserved) {
    }

    public record GetStickyHardwareFaults(boolean cANInit, boolean cANSend, boolean cANRx, boolean cANSetId, boolean eEPROMRead, boolean eEPROMWrite, boolean aDCInit, boolean cRCInit, boolean dACInit, boolean fDCANInit, boolean i2CInit, boolean sYSClockInit, boolean sPIInit, boolean timerInit, boolean uSARTInit, boolean cSAChannelInit, boolean cSAChannelRead, boolean cSAChannelInvalid, long reserved) {
    }

    public record GetHardwareFaults(boolean cANInit, boolean cANSend, boolean cANRx, boolean cANSetId, boolean eEPROMRead, boolean eEPROMWrite, boolean aDCInit, boolean cRCInit, boolean dACInit, boolean fDCANInit, boolean i2CInit, boolean sYSClockInit, boolean sPIInit, boolean timerInit, boolean uSARTInit, boolean cSAChannelInit, boolean cSAChannelRead, boolean cSAChannelInvalid, long reserved) {
    }

    public record ClearFaults() {
    }

    public record Identify() {
    }

    public record GetVersion(int firmwareFix, int firmwareMinor, int firmwareYear, int hardwareMinor, int hardwareMajor, int reserved) {
    }

    public record USBCheck() {
    }

    public record SetCANID(int id) {
    }
}

