/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.config;

import com.revrobotics.jni.CANCommonJNI;
import com.revrobotics.jni.CANServoHubJNI;
import com.revrobotics.jni.CANSparkJNI;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseConfig {
    private Map<Integer, Object> parameters = new HashMap<Integer, Object>();
    private GetParameteraTypeFunctionPtr getParameterTypeFuncPtr;

    protected BaseConfig(CANType canType) {
        this.getParameterTypeFuncPtr = canType == CANType.kSpark ? CANSparkJNI::c_Spark_GetParameterType : CANServoHubJNI::c_ServoHub_GetParameterType;
    }

    protected void putParameter(int parameterId, int value) {
        this.parameters.put(parameterId, value);
    }

    protected void putParameter(int parameterId, float value) {
        this.parameters.put(parameterId, Float.valueOf(value));
    }

    protected void putParameter(int parameterId, boolean value) {
        this.parameters.put(parameterId, value);
    }

    private void putParameter(int parameterId, Object value) {
        this.parameters.put(parameterId, value);
    }

    protected Object getParameter(int parameterId) {
        return this.parameters.get(parameterId);
    }

    protected Object getParameter(BaseConfig fromConfig, int parameterId) {
        return fromConfig.getParameter(parameterId);
    }

    protected void removeParameter(int parameterId) {
        this.parameters.remove(parameterId);
    }

    protected void removeParameter(BaseConfig fromConfig, int parameterId) {
        fromConfig.removeParameter(parameterId);
    }

    protected void apply(BaseConfig config) {
        for (Map.Entry<Integer, Object> parameter : config.parameters.entrySet()) {
            this.putParameter((int)parameter.getKey(), parameter.getValue());
        }
    }

    public String flatten() {
        String flattenedString = "";
        for (Map.Entry<Integer, Object> parameter : this.parameters.entrySet()) {
            switch (this.getParameterTypeFuncPtr.getParameterTypeFunction(parameter.getKey())) {
                case 1: {
                    flattenedString = flattenedString + CANCommonJNI.c_REVLib_FlattenParameterInt32(parameter.getKey(), (Integer)parameter.getValue());
                    break;
                }
                case 2: {
                    flattenedString = flattenedString + CANCommonJNI.c_REVLib_FlattenParameterUint32(parameter.getKey(), (Integer)parameter.getValue());
                    break;
                }
                case 3: {
                    flattenedString = flattenedString + CANCommonJNI.c_REVLib_FlattenParameterFloat(parameter.getKey(), ((Float)parameter.getValue()).floatValue());
                    break;
                }
                case 4: {
                    flattenedString = flattenedString + CANCommonJNI.c_REVLib_FlattenParameterBool(parameter.getKey(), (Boolean)parameter.getValue());
                }
            }
        }
        return flattenedString;
    }

    protected static enum CANType {
        kSpark(0),
        kServoHub(1);

        public final int value;

        private CANType(int value) {
            this.value = value;
        }
    }

    private static interface GetParameteraTypeFunctionPtr {
        public int getParameterTypeFunction(int var1);
    }
}

