/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.config.SparkParameters;

public class EncoderConfig
extends BaseConfig {
    public EncoderConfig() {
        super(BaseConfig.CANType.kSpark);
    }

    public EncoderConfig apply(EncoderConfig config) {
        super.apply(config);
        return this;
    }

    public EncoderConfig countsPerRevolution(int cpr) {
        this.putParameter(SparkParameters.kEncoderCountsPerRev.value, cpr);
        return this;
    }

    public EncoderConfig inverted(boolean inverted) {
        this.putParameter(SparkParameters.kEncoderInverted.value, inverted);
        return this;
    }

    public EncoderConfig positionConversionFactor(double factor) {
        this.putParameter(SparkParameters.kPositionConversionFactor.value, (float)factor);
        return this;
    }

    public EncoderConfig velocityConversionFactor(double factor) {
        this.putParameter(SparkParameters.kVelocityConversionFactor.value, (float)factor);
        return this;
    }

    public EncoderConfig quadratureAverageDepth(int depth) {
        this.putParameter(SparkParameters.kEncoderAverageDepth.value, depth);
        return this;
    }

    public EncoderConfig quadratureMeasurementPeriod(int periodMs) {
        this.putParameter(SparkParameters.kEncoderSampleDelta.value, periodMs << 1);
        return this;
    }

    public EncoderConfig uvwAverageDepth(int depth) {
        this.putParameter(SparkParameters.kUvwSensorAverageDepth.value, switch (depth) {
            case 1 -> 0;
            case 2 -> 1;
            case 4 -> 2;
            default -> 3;
        });
        return this;
    }

    public EncoderConfig uvwMeasurementPeriod(int periodMs) {
        double rate = (double)periodMs / 1000.0;
        this.putParameter(SparkParameters.kUvwSensorSampleRate.value, (float)rate);
        return this;
    }
}

