/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.revlib.support.PlainSpark;
import com.revrobotics.servohub.ServoHub;
import com.revrobotics.spark.SparkBase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class REVLibDeviceManager {
    private static final Logger logger = Logger.getLogger(REVLibDeviceManager.class.getName());
    static final Map<Integer, ServoHub> servoHubs = new ConcurrentHashMap<Integer, ServoHub>();
    static final Map<Integer, SparkBase> sparks = new ConcurrentHashMap<Integer, SparkBase>();
    static final Map<Integer, PowerHub> powerHubs = new ConcurrentHashMap<Integer, PowerHub>();
    static final Map<Integer, PneumaticHub> pneumaticHubs = new ConcurrentHashMap<Integer, PneumaticHub>();
    public static final ReentrantLock lock = new ReentrantLock();
    private Detector detector = null;

    public REVLibDeviceManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (SparkBase spark : sparks.values()) {
                spark.close();
            }
            for (ServoHub servoHub : servoHubs.values()) {
                servoHub.close();
            }
        }));
    }

    public void registerToDetector(Detector detector) {
        detector.addScanCallback((devices, added, removed, changed) -> {
            this.detector = detector;
            List<FRCCanDevice> allDevices = devices.stream().flatMap(tree -> Stream.concat(tree.children().stream(), Stream.of(tree.root()))).toList();
            logger.info("Taking lock for processing REVLib devices");
            lock.lock();
            try {
                logger.info("Processing device list: " + String.valueOf(allDevices));
                this.processServoHubs(allDevices);
                this.processSparks(allDevices);
                this.processPowerHubs(detector.canBridge, allDevices);
                this.processPneumaticHubs(detector.canBridge, allDevices);
            }
            finally {
                lock.unlock();
            }
            logger.info("Done processing REVLib devices");
        });
    }

    private void processPneumaticHubs(CanBridge bridge, List<FRCCanDevice> allDevices) {
        logger.info("Processing Pneumatic Hubs");
        List<FRCCanDevice> pneumaticHubDevices = allDevices.stream().filter(device -> device.type() == RecognizedDevice.PH).toList();
        pneumaticHubs.entrySet().removeIf(pneumaticHub -> pneumaticHubDevices.stream().noneMatch(pneumaticHubDevice -> ((Integer)pneumaticHub.getKey()).intValue() == pneumaticHubDevice.id()));
        for (FRCCanDevice pneumaticHubDevice : pneumaticHubDevices) {
            if (this.detector.canBridge.getBusOrNull(pneumaticHubDevice.descriptor()) == null) break;
            if (pneumaticHubs.get(pneumaticHubDevice.id()) != null) continue;
            logger.info("Adding PH " + pneumaticHubDevice.id() + " for uuid " + String.valueOf(pneumaticHubDevice.uuid()));
            CanBus bus = bridge.getBusOrNull(pneumaticHubDevice.descriptor());
            PneumaticHub hub = new PneumaticHub(bridge, bus, pneumaticHubDevice.id());
            pneumaticHubs.put(pneumaticHubDevice.id(), hub);
        }
    }

    private void processPowerHubs(CanBridge bridge, List<FRCCanDevice> allDevices) {
        logger.info("Processing Power Hubs");
        List<FRCCanDevice> powerHubDevices = allDevices.stream().filter(device -> device.type() == RecognizedDevice.PDH).toList();
        powerHubs.entrySet().removeIf(powerHub -> powerHubDevices.stream().noneMatch(powerHubDevice -> ((Integer)powerHub.getKey()).intValue() == powerHubDevice.id()));
        for (FRCCanDevice powerHubDevice : powerHubDevices) {
            if (this.detector.canBridge.getBusOrNull(powerHubDevice.descriptor()) == null) break;
            if (powerHubs.get(powerHubDevice.id()) != null) continue;
            logger.info("Adding PDH " + powerHubDevice.id() + " for uuid " + String.valueOf(powerHubDevice.uuid()));
            CanBus bus = bridge.getBusOrNull(powerHubDevice.descriptor());
            PowerHub hub = new PowerHub(bridge, bus, powerHubDevice.id());
            powerHubs.put(powerHubDevice.id(), hub);
        }
    }

    private void processServoHubs(List<FRCCanDevice> allDevices) {
        logger.info("Processing Servo Hubs");
        List<FRCCanDevice> servoHubDevices = allDevices.stream().filter(device -> device.type() == RecognizedDevice.SERVO_HUB).toList();
        servoHubs.entrySet().removeIf(servoHub -> this.closeIfNoneMatch((ServoHub)servoHub.getValue(), servoHubDevices));
        for (FRCCanDevice servoHubDevice : servoHubDevices) {
            if (this.detector.canBridge.getBusOrNull(servoHubDevice.descriptor()) == null) break;
            if (servoHubs.get(servoHubDevice.id()) != null) continue;
            logger.info("Adding SH " + servoHubDevice.id() + " for uuid " + String.valueOf(servoHubDevice.uuid()));
            ServoHub hub = new ServoHub(servoHubDevice.id());
            hub.setCANTimeout(100);
            hub.setCANMaxRetries(2);
            hub.setPeriodicFrameTimeout(200);
            servoHubs.put(servoHubDevice.id(), hub);
        }
    }

    private synchronized void processSparks(List<FRCCanDevice> allDevices) {
        logger.info("Processing Sparks");
        List<FRCCanDevice> sparkDevices = allDevices.stream().filter(device -> device.type() == RecognizedDevice.SPARK_FLEX || device.type() == RecognizedDevice.SPARK_MAX || device.type() == RecognizedDevice.UNKNOWN_SPARK).toList();
        sparks.entrySet().removeIf(spark -> this.closeIfNoneMatch((SparkBase)spark.getValue(), sparkDevices));
        for (FRCCanDevice sparkDevice : sparkDevices) {
            if (this.detector.canBridge.getBusOrNull(sparkDevice.descriptor()) == null) break;
            if (sparks.get(sparkDevice.id()) != null) continue;
            logger.info("Adding SPARK " + sparkDevice.id() + " for uuid " + String.valueOf(sparkDevice.uuid()));
            PlainSpark spark2 = new PlainSpark(sparkDevice.id());
            spark2.setCANMaxRetries(2);
            spark2.setCANTimeout(50);
            sparks.put(sparkDevice.id(), (SparkBase)spark2);
        }
    }

    private boolean closeIfNoneMatch(ServoHub servoHub, List<FRCCanDevice> devices) {
        boolean shouldClose = devices.stream().noneMatch(servoHubDevice -> servoHub.getDeviceId() == servoHubDevice.id());
        if (shouldClose) {
            servoHub.close();
        }
        return shouldClose;
    }

    private boolean closeIfNoneMatch(SparkBase spark, List<FRCCanDevice> devices) {
        boolean shouldClose = devices.stream().noneMatch(sparkDevice -> spark.getDeviceId() == sparkDevice.id());
        if (shouldClose) {
            spark.close();
        }
        return shouldClose;
    }

    public ServoHub getServoHub(int deviceId) {
        return servoHubs.get(deviceId);
    }

    public SparkBase getSpark(int deviceId) {
        return sparks.get(deviceId);
    }

    public PowerHub getPowerHub(int deviceId) {
        return powerHubs.get(deviceId);
    }

    public PneumaticHub getPneumaticHub(int deviceId) {
        return pneumaticHubs.get(deviceId);
    }
}

