/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.polling;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.CanBusData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessagePollingService {
    public static final int SCAN_MAX_AGE = 1000;
    private final CanBridge canBridge;
    private List<CanBus> currentDevices = new ArrayList<CanBus>();

    public MessagePollingService(CanBridge canBridge) {
        this.canBridge = canBridge;
    }

    public AllCanFrames iterate() {
        this.canBridge.scanForBuses();
        CanBus[] scannedBuses = this.canBridge.getBuses();
        this.currentDevices = List.of(scannedBuses);
        HashMap<String, CanBusData> allCanTraffic = new HashMap<String, CanBusData>();
        for (CanBus bus : scannedBuses) {
            CanMessage[] messages = this.canBridge.getLatestMessages(bus, 1000);
            CanBusData thisBus = new CanBusData(bus.descriptor(), List.of(messages));
            allCanTraffic.put(bus.descriptor(), thisBus);
        }
        return new AllCanFrames(allCanTraffic);
    }

    public List<CanBus> getCurrentDevices() {
        return this.currentDevices;
    }
}

