/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.revui.app.exceptions.NotRunningInConveyor;
import dev.hydraulic.conveyor.control.SoftwareUpdateController;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/update"})
public class UpdateController {
    @ApiResponses(value={@ApiResponse(responseCode="503", description="app is not running in packaged mode")})
    @PostMapping(value={"/"})
    public ResponseEntity<UpdateResponse> checkForUpdates() {
        final SoftwareUpdateController controller = SoftwareUpdateController.getInstance();
        if (controller == null || controller.canTriggerUpdateCheckUI() != SoftwareUpdateController.Availability.AVAILABLE) {
            throw new NotRunningInConveyor();
        }
        if (!this.isUpToDate(controller)) {
            new Timer().schedule(new TimerTask(this){

                @Override
                public void run() {
                    controller.triggerUpdateCheckUI();
                }
            }, 100L);
            return ResponseEntity.ok((Object)new UpdateResponse(false));
        }
        return ResponseEntity.ok((Object)new UpdateResponse(true));
    }

    @ApiResponses(value={@ApiResponse(responseCode="503", description="app is not running in packaged mode")})
    @GetMapping(value={"/"})
    public UpdateResponse isUpToDate() {
        SoftwareUpdateController controller = SoftwareUpdateController.getInstance();
        if (controller == null) {
            throw new NotRunningInConveyor();
        }
        return new UpdateResponse(this.isUpToDate(controller));
    }

    private boolean isUpToDate(SoftwareUpdateController controller) {
        try {
            SoftwareUpdateController.Version latestVersion = controller.getCurrentVersionFromRepository();
            if (latestVersion == null) {
                return true;
            }
            return latestVersion.compareTo(controller.getCurrentVersion()) <= 0;
        }
        catch (SoftwareUpdateController.UpdateCheckException e) {
            return true;
        }
    }

    public record UpdateResponse(boolean isUpToDate) {
    }
}

