/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.UserDefinedArrayType;
import org.hibernate.tool.schema.internal.StandardUserDefinedTypeExporter;
import org.hibernate.type.SqlTypes;

public class OracleUserDefinedTypeExporter
extends StandardUserDefinedTypeExporter {
    public OracleUserDefinedTypeExporter(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String[] getSqlCreateStrings(UserDefinedArrayType userDefinedType, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedNameParser.NameParts typeName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(userDefinedType.getCatalog(), userDefinedType.isCatalogQuoted()), Identifier.toIdentifier(userDefinedType.getSchema(), userDefinedType.isSchemaQuoted()), userDefinedType.getNameIdentifier());
        String arrayTypeName = context.format(typeName);
        Integer arraySqlTypeCode = userDefinedType.getArraySqlTypeCode();
        String elementType = userDefinedType.getElementTypeName();
        if (arraySqlTypeCode == null || arraySqlTypeCode == 4000) {
            return new String[]{"create or replace type " + arrayTypeName + " as table of " + elementType};
        }
        int arrayLength = userDefinedType.getArrayLength();
        Integer elementSqlTypeCode = userDefinedType.getElementSqlTypeCode();
        Integer elementDdlTypeCode = userDefinedType.getElementDdlTypeCode();
        String jsonTypeName = metadata.getDatabase().getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, this.dialect);
        String valueExpression = this.determineValueExpression("t.value", elementSqlTypeCode, elementDdlTypeCode, elementType);
        String jsonElementType = this.determineJsonElementType(elementSqlTypeCode, elementDdlTypeCode, elementType);
        boolean isBooleanType = elementType.equalsIgnoreCase("boolean");
        return new String[]{"create or replace type " + arrayTypeName + " as varying array(" + arrayLength + ") of " + elementType, "create or replace function " + arrayTypeName + "_cmp(a in " + arrayTypeName + ", b in " + arrayTypeName + ") return number deterministic is begin if a is null or b is null then return null; end if; for i in 1 .. least(a.count,b.count) loop if a(i) is null or b(i) is null then return null;elsif a(i)>b(i) then return 1;elsif a(i)<b(i) then return -1; end if; end loop; if a.count=b.count then return 0; elsif a.count>b.count then return 1; else return -1; end if; end;", "create or replace function " + arrayTypeName + "_distinct(a in " + arrayTypeName + ", b in " + arrayTypeName + ") return number deterministic is begin if a is null and b is null then return 0; end if; if a is null or b is null or a.count <> b.count then return 1; end if; for i in 1 .. a.count loop if (a(i) is null)<>(b(i) is null) or a(i)<>b(i) then return 1; end if; end loop; return 0; end;", "create or replace function " + arrayTypeName + "_position(arr in " + arrayTypeName + ", elem in " + this.getRawTypeName(elementType) + ", startPos in number default 1) return number deterministic is begin if arr is null then return null; end if; if elem is null then for i in startPos .. arr.count loop if arr(i) is null then return i; end if; end loop; else for i in startPos .. arr.count loop if arr(i)=elem then return i; end if; end loop; end if; return 0; end;", "create or replace function " + arrayTypeName + "_length(arr in " + arrayTypeName + ") return number deterministic is begin if arr is null then return null; end if; return arr.count; end;", this.createOrReplaceConcatFunction(arrayTypeName), "create or replace function " + arrayTypeName + "_includes(haystack in " + arrayTypeName + ", needle in " + arrayTypeName + ", nullable in number) return number deterministic is found number(1,0); begin if haystack is null or needle is null then return null; end if; for i in 1 .. needle.count loop found := 0; for j in 1 .. haystack.count loop if nullable = 1 and needle(i) is null and haystack(j) is null or needle(i)=haystack(j) then found := 1; exit; end if; end loop; if found = 0 then return 0; end if;end loop; return 1; end;", "create or replace function " + arrayTypeName + "_intersects(haystack in " + arrayTypeName + ", needle in " + arrayTypeName + ", nullable in number) return number deterministic is begin if haystack is null or needle is null then return null; end if; if needle.count = 0 then return 1; end if; for i in 1 .. needle.count loop for j in 1 .. haystack.count loop if nullable = 1 and needle(i) is null and haystack(j) is null or needle(i)=haystack(j) then return 1; end if; end loop; end loop; return 0; end;", "create or replace function " + arrayTypeName + "_get(arr in " + arrayTypeName + ", idx in number) return " + this.getRawTypeName(elementType) + " deterministic is begin if arr is null or idx is null or arr.count < idx then return null; end if; return arr(idx); end;", "create or replace function " + arrayTypeName + "_set(arr in " + arrayTypeName + ", idx in number, elem in " + this.getRawTypeName(elementType) + ") return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is not null then for i in 1 .. arr.count loop res.extend; res(i) := arr(i); end loop; for i in arr.count+1 .. idx loop res.extend; end loop; else for i in 1 .. idx loop res.extend; end loop; end if; res(idx) := elem; return res; end;", "create or replace function " + arrayTypeName + "_remove(arr in " + arrayTypeName + ", elem in " + this.getRawTypeName(elementType) + ") return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null then return null; end if; if elem is null then for i in 1 .. arr.count loop if arr(i) is not null then res.extend; res(res.last) := arr(i); end if; end loop; else for i in 1 .. arr.count loop if arr(i) is null or arr(i)<>elem then res.extend; res(res.last) := arr(i); end if; end loop; end if; return res; end;", "create or replace function " + arrayTypeName + "_remove_index(arr in " + arrayTypeName + ", idx in number) return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null or idx is null then return arr; end if; for i in 1 .. arr.count loop if i<>idx then res.extend; res(res.last) := arr(i); end if; end loop; return res; end;", "create or replace function " + arrayTypeName + "_slice(arr in " + arrayTypeName + ", startIdx in number, endIdx in number) return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null or startIdx is null or endIdx is null then return null; end if; for i in startIdx .. least(arr.count,endIdx) loop res.extend; res(res.last) := arr(i); end loop; return res; end;", "create or replace function " + arrayTypeName + "_replace(arr in " + arrayTypeName + ", old in " + this.getRawTypeName(elementType) + ", elem in " + this.getRawTypeName(elementType) + ") return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null then return null; end if; if old is null then for i in 1 .. arr.count loop res.extend; res(res.last) := coalesce(arr(i),elem); end loop; else for i in 1 .. arr.count loop res.extend; if arr(i) = old then res(res.last) := elem; else res(res.last) := arr(i); end if; end loop; end if; return res; end;", "create or replace function " + arrayTypeName + "_trim(arr in " + arrayTypeName + ", elems number) return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null or elems is null then return null; end if; if arr.count < elems then raise_application_error (-20000, 'number of elements to trim must be between 0 and '||arr.count); end if;for i in 1 .. arr.count-elems loop res.extend; res(i) := arr(i); end loop; return res; end;", "create or replace function " + arrayTypeName + "_fill(elem in " + this.getRawTypeName(elementType) + ", elems number) return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if elems is null then return null; end if; if elems<0 then raise_application_error (-20000, 'number of elements must be greater than or equal to 0'); end if;for i in 1 .. elems loop res.extend; res(i) := elem; end loop; return res; end;", "create or replace function " + arrayTypeName + "_positions(arr in " + arrayTypeName + ", elem in " + this.getRawTypeName(elementType) + ") return sdo_ordinate_array deterministic is res sdo_ordinate_array:=sdo_ordinate_array(); begin if arr is null then return null; end if; if elem is null then for i in 1 .. arr.count loop if arr(i) is null then res.extend; res(res.last):=i; end if; end loop; else for i in 1 .. arr.count loop if arr(i)=elem then res.extend; res(res.last):=i; end if; end loop; end if; return res; end;", "create or replace function " + arrayTypeName + "_to_string(arr in " + arrayTypeName + ", sep in varchar2, nullVal in varchar2) return varchar2 deterministic is res varchar2(4000):=''; begin if arr is null or sep is null then return null; end if; for i in 1 .. arr.count loop if arr(i) is not null then if length(res)<>0 then res:=res||sep; end if; " + (!isBooleanType ? "res:=res||arr(i); " : "if arr(i) then res:=res||'true'; else res:=res||'false'; end if; ") + "elsif nullVal is not null then if length(res)<>0 then res:=res||sep; end if; res:=res||nullVal; end if; end loop; return res; end;", "create or replace function " + arrayTypeName + "_from_json(arr in " + jsonTypeName + ") return " + arrayTypeName + " deterministic is res " + arrayTypeName + ":=" + arrayTypeName + "(); begin if arr is null then return null; end if; select " + valueExpression + " bulk collect into res from json_table(arr,'$[*]' columns (value " + jsonElementType + " path '$')) t; return res; end;"};
    }

    @Override
    public String[] getSqlDropStrings(UserDefinedArrayType userDefinedType, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedNameParser.NameParts typeName = new QualifiedNameParser.NameParts(Identifier.toIdentifier(userDefinedType.getCatalog(), userDefinedType.isCatalogQuoted()), Identifier.toIdentifier(userDefinedType.getSchema(), userDefinedType.isSchemaQuoted()), userDefinedType.getNameIdentifier());
        String arrayTypeName = context.format(typeName);
        Integer arraySqlTypeCode = userDefinedType.getArraySqlTypeCode();
        if (arraySqlTypeCode == null || arraySqlTypeCode == 4000) {
            return new String[]{this.buildDropTypeSqlString(arrayTypeName)};
        }
        return new String[]{this.buildDropTypeSqlString(arrayTypeName), this.buildDropFunctionSqlString(arrayTypeName + "_cmp"), this.buildDropFunctionSqlString(arrayTypeName + "_distinct"), this.buildDropFunctionSqlString(arrayTypeName + "_position"), this.buildDropFunctionSqlString(arrayTypeName + "_length"), this.buildDropFunctionSqlString(arrayTypeName + "_concat"), this.buildDropFunctionSqlString(arrayTypeName + "_includes"), this.buildDropFunctionSqlString(arrayTypeName + "_intersects"), this.buildDropFunctionSqlString(arrayTypeName + "_get"), this.buildDropFunctionSqlString(arrayTypeName + "_set"), this.buildDropFunctionSqlString(arrayTypeName + "_remove"), this.buildDropFunctionSqlString(arrayTypeName + "_remove_index"), this.buildDropFunctionSqlString(arrayTypeName + "_slice"), this.buildDropFunctionSqlString(arrayTypeName + "_replace"), this.buildDropFunctionSqlString(arrayTypeName + "_trim"), this.buildDropFunctionSqlString(arrayTypeName + "_fill"), this.buildDropFunctionSqlString(arrayTypeName + "_positions"), this.buildDropFunctionSqlString(arrayTypeName + "_to_string"), this.buildDropFunctionSqlString(arrayTypeName + "_from_json")};
    }

    private String buildDropTypeSqlString(String arrayTypeName) {
        if (this.dialect.supportsIfExistsBeforeTypeName()) {
            return "drop type if exists " + arrayTypeName + " force";
        }
        return "drop type " + arrayTypeName + " force";
    }

    private String buildDropFunctionSqlString(String functionTypeName) {
        if (this.supportsIfExistsBeforeFunctionName()) {
            return "drop function if exists " + functionTypeName;
        }
        return "drop function " + functionTypeName;
    }

    private boolean supportsIfExistsBeforeFunctionName() {
        return this.dialect.getVersion().isSameOrAfter(23);
    }

    private String determineValueExpression(String expression, int elementSqlTypeCode, Integer elementDdlTypeCode, String elementType) {
        switch (elementSqlTypeCode) {
            case 91: {
                return "to_date(" + expression + ",'YYYY-MM-DD')";
            }
            case 92: {
                return "to_timestamp(" + expression + ",'hh24:mi:ss')";
            }
            case 93: {
                return "to_timestamp(" + expression + ",'YYYY-MM-DD\"T\"hh24:mi:ss.FF9')";
            }
            case 2014: 
            case 3003: {
                return "to_timestamp_tz(" + expression + ",'YYYY-MM-DD\"T\"hh24:mi:ss.FF9TZH:TZM')";
            }
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "xmlcast(xmlcdata(" + expression + ") as " + elementType + ")";
            }
            case 3000: {
                return "hextoraw(replace(" + expression + ",'-',''))";
            }
            case -7: {
                return "decode(" + expression + ",'true',1,'false',0,null)";
            }
            case 16: {
                if (!SqlTypes.isNumericType(elementDdlTypeCode)) break;
                return "decode(" + expression + ",'true',1,'false',0,null)";
            }
        }
        return expression;
    }

    private String determineJsonElementType(Integer elementSqlTypeCode, Integer elementDdlTypeCode, String elementType) {
        switch (elementSqlTypeCode) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "clob";
            }
            case 16: {
                if (!SqlTypes.isNumericType(elementDdlTypeCode)) {
                    return elementType;
                }
            }
            case -7: 
            case 91: 
            case 92: 
            case 93: 
            case 2014: 
            case 3000: 
            case 3003: {
                return "varchar2(4000)";
            }
        }
        return elementType;
    }

    protected String createOrReplaceConcatFunction(String arrayTypeName) {
        return this.createOrReplaceConcatFunction(arrayTypeName, 5);
    }

    protected String createOrReplaceConcatFunction(String arrayTypeName, int maxConcatParams) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("create or replace function ").append(arrayTypeName).append("_concat(");
        sb.append("arr0 in ").append(arrayTypeName).append(",arr1 in ").append(arrayTypeName);
        for (int i2 = 2; i2 < maxConcatParams; ++i2) {
            sb.append(",arr").append(i2).append(" in ").append(arrayTypeName).append(" default ").append(arrayTypeName).append("()");
        }
        sb.append(") return ").append(arrayTypeName).append(" deterministic is res ").append(arrayTypeName).append("; begin if ");
        String separator = "";
        for (i = 0; i < maxConcatParams; ++i) {
            sb.append(separator).append("arr").append(i).append(" is null");
            separator = " or ";
        }
        sb.append(" then return null; end if; ");
        sb.append("select * bulk collect into res from (");
        separator = "";
        for (i = 0; i < maxConcatParams; ++i) {
            sb.append(separator).append("select * from table(arr").append(i).append(')');
            separator = " union all ";
        }
        return sb.append("); return res; end;").toString();
    }

    protected String getRawTypeName(String typeName) {
        int paren = typeName.indexOf(40);
        if (paren > 0) {
            int parenEnd = typeName.lastIndexOf(41);
            return parenEnd + 1 == typeName.length() ? typeName.substring(0, paren) : typeName.substring(0, paren) + typeName.substring(parenEnd + 1);
        }
        return typeName;
    }
}

