/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.contributor.CompositeHealthContributor;
import org.springframework.boot.health.contributor.CompositeHealthContributorAdapter;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.boot.health.contributor.HealthIndicatorAdapter;
import org.springframework.lang.Contract;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ReactiveHealthContributor {
    public HealthContributor asHealthContributor();

    @Contract(value="!null -> !null")
    public static @Nullable ReactiveHealthContributor adapt(@Nullable HealthContributor contributor) {
        if (contributor == null) {
            return null;
        }
        if (contributor instanceof HealthIndicator) {
            HealthIndicator healthIndicator = (HealthIndicator)contributor;
            return new HealthIndicatorAdapter(healthIndicator);
        }
        if (contributor instanceof CompositeHealthContributor) {
            CompositeHealthContributor compositeHealthContributor = (CompositeHealthContributor)contributor;
            return new CompositeHealthContributorAdapter(compositeHealthContributor);
        }
        throw new IllegalStateException("Unknown 'contributor' type");
    }
}

