# REV Hardware Client 2 Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.3.0]

- Adds support for running SPARK on telemetry page
- Adds support for running SPARK in control types other than duty cycle
- Improves PDH channels card to resemble the physical layout of the channels
- Improves SPARK Run UI to enhance PID tuning experience
- Improves performance of SPARK UI
- Improves device drawer UI
  - Makes better use of white space
  - Keeps header fixed at the top when content is scrollable
- Improves scrolling experience in SPARK Configuration and Utilities pages
- Fixes issue where the app locks up when trying to close on Mac and Linux
- Fixes issue with telemetry signals between different devices being out of sync
- Fixes issue where adding signals to AScope would sometimes not work
- Fixes telemetry page resetting and losing all progress when switching tabs

## [0.2.2]

- Fixes issue with DFU updating on Ubuntu
- Fixes UI crash when opening a device with no available releases
- Fixes rendering issues when resizing/moving the window
- Fixes links opening in another chromium window
- Fixes error when clicking support email
- Fixes issue where SPARK MAX bulk updates would not continue past updating the bridge device
- Fixes image and naming of roboRIO in device list
- Fixes inability to undo reset safe parameters on a SPARK
- Adds units to applicable parameters in SPARK configuration page
- Improves speed of fetching all parameters from a SPARK
- Improves download page
- Improves about page
- Ignores devices from other vendors in device list. This will be re-enabled in the future once they can be enumerated and displayed properly.

### Known Issues

- No clear indication to the user that the application is loading devices when connected to a large CAN bus
- Signals on SPARK summary page pop in and out if the corresponding status frame period is high enough
- roboRIO pops in and out of the device list

## [0.2.1]

- Fixes AdvantageScope theming not syncing with rest of app
- Fixes app not loading past splash screen on macOS
- Fixes DFU updating not working on macOS

## [0.2.0]

Initial beta release for REV Hardware Client 2

- Fixes crash when unplugging USB from a device
- Improves performance of device pages

### Known Issues

- The bridge device in the device list can be incorrect sometimes
- The app doesn't load on macOS unless libusb is installed via homebrew

## [0.1.9]

- Fixes issue where opening the about page forces an update if one is available
- Fixes issue where the update badge on the device list persists after the device has updated
- Fixes issue causing devices to hang for a very long period of time
- Adds ability keep track of unpersisted parameter changes when switching away from a SPARK device including CAN ID
- Adds badge in device list for devices with unsaved changes
- Adds protections from setting out of range CAN IDs and duplicate CAN IDs for the same device type
- Adds ability to update hubs already in bootloader mode
- Improves device drawer header
- Improves SPARK configuration page UI and UX
  - Adds confirmation modals for resetting parameters
  - Adds ability to undo changes for individual parameters and all parameters
  - Adds info icon for description tooltip
- Improves Servo Hub UI
- Improves reliability of detecting connected devices
- Updates styling of unpersisted parameters to be bold instead of red
- Removes right click in most areas of the application

## [0.1.8]

- Fixes updating DFU devices
- Moves run tab to new utilities tab
- Adds absolute encoder zeroing utility

## [0.1.7]

- Fixes loading the UI

## [0.1.6]

- Adds ability to update multiple devices
- Adds indicator to display that an update is available for a device
- Adds info tooltips for parts of device pages
- Adds support for fetching Pneumatic Hub firmware version
- Adds beta disclaimer banner
- Fixes CAN bus panel showing when there are no other devices on the bus
- Fixes crash on Linux using chromium
- Fixes not being able to update devices via recovery mode
- Fixes updating SPARKs via CAN
- Fixes not being able to update hubs connected directly via USB
- Improves overall experience with updating devices
- Improves dialog for outdated REV devices not supported by Hardware Client 2
- Improves general performance and reliability

### Known issues:

- The UI doesn't load correctly. It is highly recommended to download 0.1.7 instead

## [0.1.5]

- Adds support for updating REV Hubs via CAN, but only after
  flashing 26.0.x via DFU
- Persists light/dark theme selection
- Improves consistency of device tree order
- Fixes USB check for Power Hub and Pneumatic Hub
- Adds instructions on how to report an issue during the beta

## [0.1.4]

- Pneumatic hub UI and functionality added
- Downloads page responsiveness and use of white space improved

## [0.1.3]

- Updates DFU screen
- Updates UI for about page, servo page, and downloads page

## [0.1.2]

- Improves UI and performance of SPARK Flex and MAX pages
  - Removes absolute encoder tool temporarily
- Improves UI and performance of PDH page
- Improves UI and behavior of recovery mode page
- Improves general UI of hardware page
  - Allows clicking behind the device drawer
  - Displays which device is selected
- Fixes issue preventing selecting a device while another device of the same type is open
- Fixes issue where devices would sometimes not show after connecting via USB
- Fixes issue with some parameters returning junk data on SPARK configuration page
- Fixes broken image link in device drawer for SPARK Flex

## [0.1.1]

- Adds Telemetry page
- Adds Servo Hub page
- Fixes MacOS support
- Fixes crash at startup on Linux
- Updates app icons

## [0.1.0]

- Fixes bug where SPARKS that are not updated appear as MAX
- Fixes sider not collapsing when device disconnected
- Improves speed of loading parameters
- Improves speed of showing devices for big buses
- Improves UI
- Adds ability to select telemetry signals for SPARK
- Resets setpoint to 0 when navigating away from SPARK
- SPARK setpoint supports typing decimals

## [0.0.18]

- Adds recovery mode functionality
- Improves SPARK functionality
  - Setting parameters
  - Reading Parameters
  - Run motor
  - Update SPARK
- Add button to browse download folder
- Fixes support for running on macOS
- Fixes bug causing random setpoint on MAX at startup
- Prevents sider from appearing over non-hardware tabs

## [0.0.17]

- Correct broken build bundled in v0.0.16
- Miscellaneous bug fixes
- Show device details in sider when a device is clicked on hardware page
- Support Spark MAX/Flex device configuration and running
- Fix hardware page device logos/images
- Initial Dark Mode theme

### Known Issues:

- Frontend errors after selecting as servohub on the hardware page
- Dark mode makes some pages unreadable
- Top navigation bar contains temporary development items

## [0.0.16]

- Miscellaneous bug fixes

## [0.0.15]

- Fix linkage on Ubuntu
- Add PCAN-Compatible tracing (must hit an endpoint to turn on)
- Add Power Hub endpoints

## [0.0.14]

- Spark Flex added
- State and behavior of parameters fixed for basic and advanced pages (Max and Flex)
- Enable and disable toggles for both Basic and Advanced pages (Max and Flex)
- Fine tuning Limits behavior on Basic page (Max and Flex)

### In Progress

- Passing Descriptor and UUID as props from device navigation

### In Progress

- Updates page
- Saving and loading configurations
- Having Search bar and persist parameters and factory reset buttons have a fixed position
- Polling parameters interval to ensure fresh values
- Client-side navigation from Hardware page to identified Spark Max device

## [0.0.13]

- Initial Spark Max version
  - Web Sockets functionality added for Input voltage and Duty Cycle Position
  - 90% of the UI is in place
  - Consistent communication with Spark Max
- Added identify device functionality to Hardware page liek Basic tab

### Known Issues

- Odd State behavior with some parameters
  - Input deadband slider on Basic tab
  - Page needs refresh to display current values
- Odd Setpoint readings despite normal functionality

### In Progress

- Toggle constrainst for both Basic and Advanced pages
- Fine tuning Limits behavior on Basic page
- Saving and loading configurations
- Having Search bar and persist parameters and factory reset buttons have a fixed position
- Polling parameters interval to ensure fresh values
- Updating CAN id
- Updates page
- Client-side navigation from Hardware page to identified Spark Max device

## [0.0.12]

Fixes libusb crash at startup

## [0.0.11]

Same as 0.0.10, but the release site isn't localhost

## [0.0.10]

### Import Note:

- To use this version of REV Hardware Client, you will need a REV device using SL Can firmware.

### Added

- Initial internal release
  - SL Can firmware support
  - Hardware Page:
    - Connected USB devices display
    - Connected CAN Bus devices display
    - List of supported device:
      - Servo Hub
      - Spark Flex
      - Spark Max
      - Power Hub
      - Pneumatic Hub
  - About Page
    - Initial UI
  - Downloads Page
    - Initial UI
    - Download files via new publishing process
  - Backend support for Detecting REV devices and interacting with and getting status frames for SPARKs and Servo Hubs.
  - Backend support for GSUSB and DFU devices

### Known Issues:

- Inconsistent image sizes for devices on Hardware Page
- Identify button
- No GSUSB Support
- SparkMAX and SparkFlex always show up as "Unknown Spark"
- Expansion / Driver / Control hub do not show up in device list
- Hardware Device sidebar doesnt appear when device element is clicked
