/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/canbridge"})
public class CanBridgeController {
    @Autowired
    CanBridge bridge;

    @GetMapping(value={"/bus/count"})
    public int getNumDevices() {
        return this.bridge.scanForBuses();
    }

    @GetMapping(value={"/bus/all"})
    public String[] getDevices() {
        this.bridge.scanForBuses();
        ArrayList<String> result = new ArrayList<String>();
        for (CanBus bus : this.bridge.getBuses()) {
            String encodedDescriptor = Base64.getUrlEncoder().withoutPadding().encodeToString(bus.descriptor().getBytes(StandardCharsets.UTF_8));
            result.add(encodedDescriptor);
        }
        return (String[])result.toArray(String[]::new);
    }

    @GetMapping(value={"/bus/{descriptor}/message/latest"})
    public CanMessage getLatestMessage(@PathVariable String descriptor) {
        String decodedDescriptor = new String(Base64.getUrlDecoder().decode(descriptor.getBytes()), StandardCharsets.UTF_8);
        this.bridge.scanForBuses();
        CanBus bus = this.bridge.getBusOrNull(decodedDescriptor);
        if (bus == null) {
            return null;
        }
        return this.bridge.getLatestMessage(bus);
    }

    @GetMapping(value={"/bus/{descriptor}/message/latest/all"})
    public CanMessage[] getLatestMessages(@PathVariable String descriptor, @RequestParam int maxAge) {
        String decodedDescriptor = new String(Base64.getUrlDecoder().decode(descriptor.getBytes()), StandardCharsets.UTF_8);
        this.bridge.scanForBuses();
        CanBus bus = this.bridge.getBusOrNull(decodedDescriptor);
        if (bus == null) {
            return null;
        }
        return this.bridge.getLatestMessages(bus, maxAge);
    }

    public static String decodeDescriptor(String descriptor) {
        return new String(Base64.getUrlDecoder().decode(descriptor.getBytes()), StandardCharsets.UTF_8);
    }

    public static String encodeDescriptor(String descriptor) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(descriptor.getBytes());
    }
}

