/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.revrobotics.canbridge.CanBridgeCallback;
import com.revrobotics.device.detection.Detector;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.revui.app.CanBridgeController;
import com.revrobotics.revui.app.devices.REVDevicesController;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class DetectionWebsocketHandler
extends TextWebSocketHandler {
    private final Logger logger = Logger.getLogger(DetectionWebsocketHandler.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Map<String, List<Detector.ScanCallback>> callbacks = new HashMap<String, List<Detector.ScanCallback>>();
    private final Map<String, CanBridgeCallback> canBridgeCallbacks = new HashMap<String, CanBridgeCallback>();
    private static boolean isLoading = false;
    @Autowired
    DeviceDaemon deviceDaemon;
    private final AtomicReference<List<DeviceTree>> currentDeviceTreeState = new AtomicReference(List.of());

    public void afterConnectionEstablished(final WebSocketSession session) {
        Detector.ScanCallback loadingCallback = this.deviceDaemon.getDetector().addScanCallback(Detector.DetectorStage.DEVICES_DETECTED, (devices, added, removed, changed) -> {
            if (!devices.isEmpty()) {
                DetectionWebsocketHandler.sendLoadingState(session, true);
            }
        });
        Detector.ScanCallback callback = this.deviceDaemon.getDetector().addScanCallback(Detector.DetectorStage.FULLY_INITIALIZED, (devicesState, added, removed, changed) -> {
            List<DeviceTree> devices = List.copyOf(devicesState);
            this.currentDeviceTreeState.set(devices);
            this.logger.info("Sending updated device tree");
            DetectionWebsocketHandler.sendDeviceTree(session, devices);
            DetectionWebsocketHandler.sendLoadingState(session, false);
        });
        CanBridgeCallback canBridgeCallback = this.deviceDaemon.getDetector().addCanBridgeCallback(new CanBridgeCallback(){

            public void onBridgeOpen() {
                DetectionWebsocketHandler.sendLoadingState(session, true);
            }

            public void onBridgeClose() {
                DetectionWebsocketHandler.sendLoadingState(session, false);
            }
        });
        this.callbacks.put(session.getId(), List.of(callback, loadingCallback));
        this.canBridgeCallbacks.put(session.getId(), canBridgeCallback);
        Thread t = new Thread(() -> {
            while (session.isOpen()) {
                try {
                    if (!isLoading) {
                        DetectionWebsocketHandler.sendDeviceTree(session, this.currentDeviceTreeState.get());
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.finest("Websocket for detection disconnected");
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private static void sendDeviceTree(WebSocketSession session, List<DeviceTree> devices) {
        try {
            List<DeviceTree> encoded = devices.stream().map(DetectionWebsocketHandler::encodeDeviceTree).toList();
            String text = mapper.writeValueAsString(encoded);
            DetectionWebsocketHandler.sendWebsocketTextMessage(session, text);
        }
        catch (JsonProcessingException e) {
            System.err.println("Error while serializing devices:\n" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Error while sending websocket:\n" + e.getMessage());
        }
    }

    private static void sendLoadingState(WebSocketSession session, boolean isLoading) {
        try {
            DetectionWebsocketHandler.isLoading = isLoading;
            String text = "{\"loading\": " + isLoading + "}";
            DetectionWebsocketHandler.sendWebsocketTextMessage(session, text);
        }
        catch (IOException e) {
            System.err.println("Error while sending websocket:\n" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendWebsocketTextMessage(WebSocketSession session, String text) throws IOException {
        WebSocketSession webSocketSession = session;
        synchronized (webSocketSession) {
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)text));
            }
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        CanBridgeCallback canBridgeCallback;
        super.afterConnectionClosed(session, status);
        List<Detector.ScanCallback> sessionCallbacks = this.callbacks.remove(session.getId());
        if (sessionCallbacks != null) {
            for (Detector.ScanCallback callback : sessionCallbacks) {
                this.deviceDaemon.getDetector().removeCallback(callback);
            }
        }
        if ((canBridgeCallback = this.canBridgeCallbacks.remove(session.getId())) != null) {
            this.deviceDaemon.getDetector().removeCanBridgeCallback(canBridgeCallback);
        }
    }

    private static DeviceTree encodeDeviceTree(DeviceTree tree) {
        List<FRCCanDevice> children = tree.children().stream().map(REVDevicesController::encodeDescriptorForDevice).toList();
        FRCCanDevice root = REVDevicesController.encodeDescriptorForDevice(tree.root());
        return new DeviceTree(root, CanBridgeController.encodeDescriptor(tree.descriptor()), children);
    }
}

