/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.download.DownloadFile;
import com.revrobotics.revui.app.download.DownloadManager;
import com.revrobotics.revui.app.download.db.DownloadChannel;
import com.revrobotics.revui.app.download.db.DownloadChannelRepository;
import com.revrobotics.revui.app.download.db.DownloadModel;
import com.revrobotics.revui.app.download.db.DownloadRepository;
import com.revrobotics.revui.app.exceptions.ChannelNotFoundException;
import com.revrobotics.revui.app.exceptions.DownloadFileNotFound;
import com.revrobotics.revui.app.exceptions.NotRunningLocallyException;
import com.revrobotics.revui.app.files.DirectoryManager;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;
import javax.swing.JFileChooser;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:3000"})
@RestController
@RequestMapping(value={"/v1/download"})
public class DownloadController {
    final DownloadRepository repository;
    final DownloadChannelRepository downloadChannelRepository;
    final DownloadManager manager;

    DownloadController(DownloadRepository downloadRepository, DownloadChannelRepository downloadChannelRepository) {
        this.repository = downloadRepository;
        this.downloadChannelRepository = downloadChannelRepository;
        this.manager = new DownloadManager(downloadRepository, downloadChannelRepository);
    }

    @Success
    @GetMapping(value={"/"})
    List<DownloadFile> listDownloadedFiles(@RequestParam(required=false) String code) {
        List<DownloadModel> models = code == null || code.isBlank() ? this.repository.findAll() : this.repository.findContainingChannelCode(code);
        return models.stream().map(DownloadModel::toDownloadFile).toList();
    }

    @Success
    @StandardExceptions
    @PostMapping(value={"/channel"})
    DownloadChannel createChannel(String code) throws ChannelNotFoundException {
        DownloadChannel channel = this.manager.createChannel(code);
        if (channel == null) {
            throw new ChannelNotFoundException(code);
        }
        return channel;
    }

    @Success
    @GetMapping(value={"/channel"})
    List<DownloadChannel> listChannels() {
        return this.downloadChannelRepository.findAll();
    }

    @Success
    @StandardExceptions
    @DeleteMapping(value={"/channel"})
    DownloadChannel deleteChannel(String code) throws ChannelNotFoundException {
        DownloadChannel channel = this.downloadChannelRepository.findByCode(code);
        if (channel == null) {
            throw new ChannelNotFoundException(code);
        }
        this.downloadChannelRepository.delete(channel);
        List<DownloadModel> releasesToDelete = this.repository.findPrereleasesWithoutChannel();
        this.repository.deleteAll(releasesToDelete);
        return channel;
    }

    @Success
    @PostMapping(value={"/sync"})
    void syncDownloadFiles() {
        this.manager.syncDatabaseFiles();
    }

    @ApiResponses(value={@ApiResponse(responseCode="200", description="found existing download"), @ApiResponse(responseCode="201", description="downloaded new file"), @ApiResponse(responseCode="404", description="file not found"), @ApiResponse(responseCode="502", description="download SHA mismatch"), @ApiResponse(responseCode="504", description="download failed")})
    @PutMapping(value={"/{id}/file"})
    ResponseEntity<Void> downloadFile(@PathVariable long id) throws DownloadFileNotFound {
        DownloadModel model = this.repository.findById(id);
        if (model == null) {
            throw new DownloadFileNotFound();
        }
        DownloadManager.DownloadState state = this.manager.downloadSoftwareIfNeeded(Path.of(model.getPath(), new String[0]), URI.create(model.getDownloadUrl()), model.getSha256());
        if (state.isSuccess()) {
            boolean isDownloaded = Files.exists(Path.of(model.getPath(), new String[0]), new LinkOption[0]);
            model.setDownloaded(isDownloaded);
            this.repository.save(model);
        }
        if (state == DownloadManager.DownloadState.ALREADY_EXISTS) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        if (state == DownloadManager.DownloadState.DOWNLOADED) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        if (state == DownloadManager.DownloadState.FAILED_TO_DOWNLOAD) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT);
        }
        if (state == DownloadManager.DownloadState.MISMATCHED_SHA) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_GATEWAY);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Success
    @StandardExceptions
    @GetMapping(value={"/{id}/file"})
    String getFile(@PathVariable long id) throws DownloadFileNotFound {
        DownloadModel model = this.repository.findById(id);
        if (model == null) {
            throw new DownloadFileNotFound();
        }
        Path path = Path.of(model.getPath(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new DownloadFileNotFound();
        }
        try {
            byte[] bytes = Files.readAllBytes(Path.of(model.getPath(), new String[0]));
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Success
    @StandardExceptions
    @GetMapping(value={"/{id}"})
    DownloadFile getFileInfo(@PathVariable long id) throws DownloadFileNotFound {
        DownloadModel model = this.repository.findById(id);
        if (model == null) {
            throw new DownloadFileNotFound();
        }
        return DownloadModel.toDownloadFile(model);
    }

    @Success
    @StandardExceptions
    @GetMapping(value={"/{id}/releaseNotes"})
    String getReleaseNotes(@PathVariable long id) throws DownloadFileNotFound {
        DownloadModel model = this.repository.findById(id);
        if (model == null) {
            throw new DownloadFileNotFound();
        }
        return model.getReleaseNotes();
    }

    @Success
    @StandardExceptions
    @DeleteMapping(value={"/{id}/file"})
    DownloadFile deleteFile(@PathVariable long id) throws DownloadFileNotFound {
        DownloadModel model = this.repository.findById(id);
        if (model == null) {
            throw new DownloadFileNotFound();
        }
        this.manager.deleteFile(model.getPath());
        boolean isDownloaded = Files.exists(Path.of(model.getPath(), new String[0]), new LinkOption[0]);
        model.setDownloaded(isDownloaded);
        model = (DownloadModel)this.repository.save(model);
        return DownloadModel.toDownloadFile(model);
    }

    @Success
    @StandardExceptions
    @GetMapping(value={"/folder"})
    public String getDownloadFolderPath(@RequestHeader(value="Host") String host) {
        if (!host.contains("localhost") && !host.contains("127.0.0.1")) {
            throw new NotRunningLocallyException();
        }
        return DirectoryManager.getDownloadsPath().toAbsolutePath().toString();
    }

    @PostMapping(value={"/folder/open"})
    public void openDownloadFolder(@RequestHeader(value="Host") String host) {
        if (!host.contains("localhost") && !host.contains("127.0.0.1")) {
            throw new NotRunningLocallyException();
        }
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        String path = DirectoryManager.getDownloadsPath().toAbsolutePath().toString();
        this.openUsingDesktop(path);
    }

    private void openUsingDesktop(String path) {
        try {
            Desktop.getDesktop().open(new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void openJFileChooser(String path) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setSelectedFile(new File(path));
        fc.setVisible(true);
        Thread t = new Thread(() -> {
            int result = fc.showOpenDialog(null);
            if (result == 0) {
                File file = fc.getSelectedFile();
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fc.setVisible(false);
        }, "File chooser Thread");
        t.start();
    }
}

