/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;

public class ArgumentTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final @Nullable Object @Nullable [] args;
    private final int @Nullable [] argTypes;

    public ArgumentTypePreparedStatementSetter(@Nullable Object @Nullable [] args, int @Nullable [] argTypes) {
        if (args == null && argTypes != null || args != null && (argTypes == null || args.length != argTypes.length)) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        int parameterPosition = 1;
        if (this.args != null && this.argTypes != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                if (arg instanceof Collection) {
                    Collection entries = (Collection)arg;
                    if (this.argTypes[i] != 2003) {
                        for (Object entry : entries) {
                            if (entry instanceof Object[]) {
                                Object[] valueArray;
                                for (Object argValue : valueArray = (Object[])entry) {
                                    this.doSetValue(ps, parameterPosition, this.argTypes[i], argValue);
                                    ++parameterPosition;
                                }
                                continue;
                            }
                            this.doSetValue(ps, parameterPosition, this.argTypes[i], entry);
                            ++parameterPosition;
                        }
                        continue;
                    }
                }
                this.doSetValue(ps, parameterPosition, this.argTypes[i], arg);
                ++parameterPosition;
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, int argType, @Nullable Object argValue) throws SQLException {
        StatementCreatorUtils.setParameterValue(ps, parameterPosition, argType, argValue);
    }

    @Override
    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

