/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.internal.parser.JavadocParser;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonArray;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonJavadocReader {
    public static ClassJavadoc readClassJavadoc(String qualifiedClassName, JsonObject json) {
        String className = qualifiedClassName.replace("$", ".");
        List<FieldJavadoc> fields = JsonJavadocReader.readFieldDocs(qualifiedClassName, json.get(RuntimeJavadocHelper.fieldsFieldName()));
        List<FieldJavadoc> enumConstants = JsonJavadocReader.readFieldDocs(qualifiedClassName, json.get(RuntimeJavadocHelper.enumConstantsFieldName()));
        List<MethodJavadoc> methods = JsonJavadocReader.readMethodDocs(qualifiedClassName, json.get(RuntimeJavadocHelper.methodsFieldName()));
        List<MethodJavadoc> constructors = JsonJavadocReader.readMethodDocs(qualifiedClassName, json.get(RuntimeJavadocHelper.constructorsFieldName()));
        String classJavadocString = json.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        return JavadocParser.parseClassJavadoc(className, classJavadocString, fields, enumConstants, methods, constructors);
    }

    private static List<FieldJavadoc> readFieldDocs(String owningClass, JsonValue fieldsValue) {
        if (fieldsValue == null) {
            return Collections.emptyList();
        }
        JsonArray fieldsArray = fieldsValue.asArray();
        ArrayList<FieldJavadoc> fields = new ArrayList<FieldJavadoc>(fieldsArray.size());
        for (JsonValue fieldValue : fieldsArray) {
            fields.add(JsonJavadocReader.readFieldDoc(owningClass, fieldValue));
        }
        return fields;
    }

    private static FieldJavadoc readFieldDoc(String owningClass, JsonValue fieldValue) {
        JsonObject field = fieldValue.asObject();
        String fieldName = field.getString(RuntimeJavadocHelper.elementNameFieldName(), null);
        String fieldDoc = field.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        return JavadocParser.parseFieldJavadoc(owningClass, fieldName, fieldDoc);
    }

    private static List<MethodJavadoc> readMethodDocs(String owningClass, JsonValue methodsValue) {
        JsonArray methodArray = methodsValue.asArray();
        ArrayList<MethodJavadoc> methods = new ArrayList<MethodJavadoc>(methodArray.size());
        for (JsonValue methodValue : methodArray) {
            methods.add(JsonJavadocReader.readMethodDoc(owningClass, methodValue));
        }
        return methods;
    }

    private static MethodJavadoc readMethodDoc(String owningClass, JsonValue methodValue) {
        JsonObject method = methodValue.asObject();
        String methodName = method.getString(RuntimeJavadocHelper.elementNameFieldName(), null);
        List<String> paramTypes = JsonJavadocReader.readParamTypes(method.get(RuntimeJavadocHelper.paramTypesFieldName()));
        String methodDoc = method.getString(RuntimeJavadocHelper.elementDocFieldName(), null);
        return JavadocParser.parseMethodJavadoc(owningClass, methodName, paramTypes, methodDoc);
    }

    private static List<String> readParamTypes(JsonValue paramTypesValue) {
        JsonArray paramTypesArray = paramTypesValue.asArray();
        ArrayList<String> paramTypes = new ArrayList<String>(paramTypesArray.size());
        for (JsonValue v : paramTypesArray) {
            paramTypes.add(v.asString());
        }
        return paramTypes;
    }
}

