/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;

public class DDLFormatterImpl
implements Formatter {
    private static final String INITIAL_LINE = System.lineSeparator() + "    ";
    private static final String OTHER_LINES = System.lineSeparator() + "       ";
    public static final DDLFormatterImpl INSTANCE = new DDLFormatterImpl();
    private static final Set<String> BREAKS = Set.of("drop", "alter", "modify", "add", "references", "foreign", "on");
    private static final Set<String> QUOTES = Set.of("\"", "`", "]", "[", "'");

    @Override
    public String format(String sql) {
        if (StringHelper.isEmpty(sql)) {
            return sql;
        }
        String lowerCaseSql = sql.toLowerCase(Locale.ROOT);
        if (lowerCaseSql.startsWith("create table")) {
            return this.formatCreateTable(sql);
        }
        if (lowerCaseSql.startsWith("create index") || lowerCaseSql.startsWith("create unique")) {
            return this.formatAlterTable(sql);
        }
        if (lowerCaseSql.startsWith("create")) {
            return INITIAL_LINE + sql;
        }
        if (lowerCaseSql.startsWith("alter table")) {
            return this.formatAlterTable(sql);
        }
        if (lowerCaseSql.startsWith("comment on")) {
            return this.formatCommentOn(sql);
        }
        return INITIAL_LINE + sql;
    }

    private String formatCommentOn(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql.replace('\n', ' '), " '[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(token);
            if (DDLFormatterImpl.isQuote(token)) {
                quoted = !quoted;
                continue;
            }
            if (quoted || !"is".equals(token)) continue;
            result.append(OTHER_LINES);
        }
        return result.toString();
    }

    private String formatAlterTable(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql.replace('\n', ' '), " (,)'[]\"", true);
        boolean first = true;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DDLFormatterImpl.isQuote(token)) {
                quoted = !quoted;
            } else if (!quoted && !first && DDLFormatterImpl.isBreak(token)) {
                result.append(OTHER_LINES);
            }
            result.append(token);
            first = false;
        }
        return result.toString();
    }

    private String formatCreateTable(String sql) {
        StringBuilder result = new StringBuilder(60).append(INITIAL_LINE);
        StringTokenizer tokens = new StringTokenizer(sql.replace('\n', ' '), "(,)'[]\"", true);
        int depth = 0;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DDLFormatterImpl.isQuote(token)) {
                quoted = !quoted;
                result.append(token);
                continue;
            }
            if (quoted) {
                result.append(token);
                continue;
            }
            if (")".equals(token) && --depth == 0) {
                result.append(INITIAL_LINE);
            }
            result.append(token);
            if (",".equals(token) && depth == 1) {
                result.append(OTHER_LINES);
            }
            if (!"(".equals(token) || ++depth != 1) continue;
            result.append(OTHER_LINES).append(' ');
        }
        return result.toString();
    }

    private static boolean isBreak(String token) {
        return BREAKS.contains(token);
    }

    private static boolean isQuote(String token) {
        return QUOTES.contains(token);
    }
}

